{$MODE OBJFPC}
uses mpi;
// pascal version of systest.c file
var	
    me, option, namelen, size : longint;
    processor_name : pchar;
function GlobalReadInteger : longint;
(*
Process zero reads an integer from stdin and broadcasts
to everyone else
*)
const typ = 999;
      zero = 0;
var me, value : longint;
begin
    MPI_Comm_rank(MPI_COMM_WORLD, me);
    if (me = 0) then
		begin
			{$i-}		
			readln(input,value);
			{$i+}
			if ( ioresult <> 0) then
				writeln('failed reading integer value from stdin');
	  	end;
    MPI_Bcast(@value, 1, MPI_INT, 0, MPI_COMM_WORLD);
    GlobalReadInteger := value;
end;	//	GlobalReadInteger

procedure Hello;
(*
Everyone exchanges a hello message with everyone else.
The hello message just comprises the sending and target nodes.
*)
const
    typ = 1;
var
    nproc, me : longint;
    node : longint;
    buffer : array[0..1] of longint;
    status : MPI_Status;
begin
	
    MPI_Comm_rank(MPI_COMM_WORLD, me);
    MPI_Comm_size(MPI_COMM_WORLD, nproc);
	
    if (me = 0) then
		begin
			writeln;
			writeln('Hello test ... show network integrity');
			writeln;
			writeln('----------');
			writeln;
			writeln;
		end;
	
    for node := 0 to nproc-1 do
		if (node <> me) then
		begin
			buffer[0] := me;
			buffer[1] := node;
			MPI_Send(@buffer, 2, MPI_INT, node, typ, MPI_COMM_WORLD);
			MPI_Recv(@buffer, 2, MPI_INT, node, typ, MPI_COMM_WORLD, status);
			
			if ((buffer[0] <> node) or (buffer[1] <> me)) then
			begin
				writeln('Hello: ',buffer[0],'<>',node,' or ',buffer[1],'<>',me);
				writeln('Mismatch on hello process ids; node = ', node);
			end;
			writeln('Hello from ',me,' to ', node);
		end;
end;	//	Hello

procedure Ring;       (* Time passing a message round a ring *)
const
    typ = 4;
var
    nproc, me : longint;
    status : MPI_Status;
    left, right : longint;
    buffer : pchar;
    lenbuf, max_len : longint;
    us_rate : double;
    start_ustime, used_ustime : double;
begin
    MPI_Comm_rank(MPI_COMM_WORLD, me);
    MPI_Comm_size(MPI_COMM_WORLD, nproc);
    left := (me + nproc - 1) mod nproc;
    right := (me + 1) mod nproc;
	
    (* Find out how big a message to use *)
	
    if (me = 0) then
		begin
			writeln;
			writeln('Ring test...time network performance');
			writeln;
			writeln('---------');
			writeln;
			writeln;						
			write('Input maximum message size: ');
		end;
    max_len := GlobalReadInteger;
    if ((max_len <= 0) or (max_len >= 4*1024*1024)) then max_len := 512*1024;
    getmem(buffer,max_len);
    if ( buffer = NIL) then
		begin
			writeln('process ',me,' could not allocate buffer of size ', max_len);
			MPI_Abort(MPI_COMM_WORLD, 7777);
		end;
	
    lenbuf := 1;
    while (lenbuf <= max_len) do
		begin
			start_ustime := MPI_Wtime;
			if (me = 0) then
			begin
				MPI_Send(buffer, lenbuf, MPI_CHAR, left, typ, MPI_COMM_WORLD);
				MPI_Recv(buffer, lenbuf, MPI_CHAR, right, typ, MPI_COMM_WORLD, status);
			end
			else 
			begin
				MPI_Recv(buffer, lenbuf, MPI_CHAR, right, typ, MPI_COMM_WORLD, status);
				MPI_Send(buffer, lenbuf, MPI_CHAR, left, typ, MPI_COMM_WORLD);
			end;
			used_ustime := MPI_Wtime - start_ustime;
		
			if (used_ustime > 0) then (* rate is megabytes per second *)
				us_rate := 1E-6*nproc*lenbuf/used_ustime
			else
				us_rate := 0.0;
			if (me = 0) then
					writeln('len=',lenbuf,' bytes, used= ',used_ustime,' sec., rate=',us_rate,' Mbytes/sec\n');
			lenbuf := lenbuf*2;
    end;
    if (me = 0) then
		writeln('clock resolution in seconds: ', MPI_Wtick:10:8);
    freemem(buffer);
end;	//	Ring

(*
procedure Stress;
procedure Globals;
*)

begin
	
    MPI_Init(argc, argv);
    MPI_Comm_rank(MPI_COMM_WORLD,me);
    MPI_Comm_size(MPI_COMM_WORLD,size);
	
    if (size < 2) then
		begin
			writeln('systest requires at least 2 processes');
			MPI_Abort(MPI_COMM_WORLD, 1);
		end;
    GetMem(processor_name,MPI_MAX_PROCESSOR_NAME+1);
    namelen := MPI_MAX_PROCESSOR_NAME;
    MPI_Get_processor_name(processor_name,namelen);
    writeln('Process ',me,' is alive on ', processor_name);

    while True do
		begin
		
			MPI_Barrier(MPI_COMM_WORLD);
			repeat
				if (me = 0) then
					writeln('Options: 0 := quit, 1 := Hello, 2 := Ring :  ');
				option := GlobalReadInteger;
			until ((option >= 0) and (option <= 4));
		
			case option of
			0:
			begin
				MPI_Finalize;
				Halt(0);
			end;	
			1:	Hello;
			2:	Ring;
(*
			3:	Stress;
			4:	Globals;
*)
			else	writeln('systest: invalid option ', option);
    	end;
end;

end.
