program Gaussian_Elimination_Prog;
{$MODE OBJFPC}
{--------------------------------------------------------------------------}
{-                                                                        -}
{-     Turbo Pascal Numerical Methods Toolbox                             -}
{-     Copyright (c) 1986, 87 by Borland International, Inc.              -}
{-                                                                        -}
{-       Purpose : This program demonstrates how to solve a system of     -}
{-                 linear equations with Gaussian elimination.            -}
{-                                                                        -}
{-       Unit    : Matrix    procedure Gaussian_Elimination               -}
{-                                                                        -}
{-  Переделка примера решения СЛАУ для FreePascal. Динамические массивы   -}
{--------------------------------------------------------------------------}

{$R+}                  { Enable range checking }
{$I-}                  { Disable I/O checking }

uses
  SysUtils, DateUtils, Matrix;

Const
  n = 2000;
var
  Dimen : integer;          { Dimen of the square matrix }
  Coefficients : TNmatrix;  { The matrix }
  Constants : TNvector;     { Constant terms in the equations }
  Solution : TNvector;      { Solution to the set of equations }
  Error : byte;             { Flags if something went wrong }
  t1, t2: TTime;

begin { program Gaussian_Elimination }
//  ClrScr;
  Dimen:=n;
  WriteLn('Создание и заполнение матрицы A...');
  InitMatrix(Dimen, Coefficients, True);
  WriteLn('Создание и заполнение вектора B...');
  InitVector(Dimen, Constants, True);
  InitVector(Dimen, Solution);

  WriteLn('Вычисляем...');
  t1:=Time;
  Gaussian_Elimination(Dimen, Coefficients, Constants, Solution, Error);
  t2:=Time;

  WriteLn('Время вычисления:');
  WriteLn(Millisecondsbetween(t2, t1)/1000:10:3, ' секунд')

end. { program Gaussian_Elimination }
