program test_numerical_methods;
{*********************************************
 * Тестирование скорости работы библиотеки
 * Numerical Methods. Решение СЛАУ.
 * Программа сделана на основе демонстрашки
 * UpperTriBackSub.
 * 
 *********************************************}

{$mode objfpc}
  uses
    SysUtils, DateUtils;

  const
    MaxR = 2000;
    MaxC = 2001;

  type
    VECTOR = array of double;
    IVECTOR = array of integer;
    MATRIX = array of array of double;
    STATUS = (Done, Nonsingular, Singular, Working);

  var
    X: VECTOR;
    A: MATRIX;
    t1, t2: TTime;
    Cond: STATUS;

  procedure GaussElim (A: MATRIX; var X: VECTOR; N: integer; var Cond: STATUS);
  var
    C, J, K, P, T: integer;
    M, SUM: double;
    Row: IVECTOR;
  begin
    SetLength(Row, MaxR+1);
    Cond := Nonsingular;
    for J := 1 to N do                      {Initialize pointer vector}
      Row[J] := J;
    for P := 1 to N - 1 do                 {Upper triangularization loop}
      begin
        for K := P + 1 to N do
          begin                                          {Find Pivot row}
            if ABS(A[Row[K], P]) > ABS(A[Row[P], P]) then
              begin
                T := Row[P];
                Row[P] := Row[K];
                Row[K] := T;
              end;
            if A[Row[P], P] = 0 then                 {Check singular matrix}
              begin
                WRITELN('A(', Row[P], ',', P, ') = ', A[Row[P], P]);
                Cond := Singular;
                Exit;
              end;
          end;
        for K := P + 1 to N do                       {Gaussian elimination}
          begin
            M := A[Row[K], P] / A[Row[P], P];
            for C := P + 1 to N + 1 do
              A[Row[K], C] := A[Row[K], C] - M * A[Row[P], C];
          end;                                 {End Gaussian elimination}
      end;                                  {End upper triangularization}
    if A[Row[N], N] = 0 then                     {Check singular matrix}
      begin
        Cond := Singular;
        Exit;
      end;
    X[N] := A[Row[N], N + 1] / A[Row[N], N];                {Back substitution}
    for K := N - 1 downto 1 do
      begin
        SUM := 0;
        for C := K + 1 to N do
          SUM := SUM + A[Row[K], C] * X[C];
        X[K] := (A[Row[K], N + 1] - SUM) / A[Row[K], K];
      end;

  end;                                     {End of procedure GaussElim}


  procedure INPUTS (var A: MATRIX; N: integer);
  Var
    i, j: integer;
  begin
    Randomize;
    WriteLn('Заполнение матрицы A...');
    For i:=1 To N Do
      For j:=1 To N Do
        A[i,j]:=Random;
  
    WriteLn('Заполнение вектора B...');
    For i:=1 To N Do
      A[i, MaxC]:=Random+1;
  end;                                   


begin                                              
  SetLength(A, MaxR+1, MaxC+1);
  SetLength(X, MaxR+1);
  INPUTS(A, MaxR);
  WriteLn('Вычисляем...');
  t1:=Time;
  GaussElim(A, X, MaxR, Cond);
  t2:=Time;
  If Cond = Done Then
  Begin
    WriteLn('Готово!');
    WriteLn('Время вычисления: ', Millisecondsbetween(t2, t1)/1000:10:3);
  End;
end.                                            
