program test_lmath;
{*********************************************
 * Тестирование скорости работы библиотеки
 * LMath\DMath. Решение СЛАУ.
 * 
 *********************************************}

{$mode objfpc}
Uses
  SysUtils, dateUtils, utypes, ulineq;
 
Const
  n = 2000;
 
var
  a: TMatrix;
  b: TVector;
  i, j: Integer;
  term: double;
  t1, t2: TTime;
 
Begin
  DimMatrix(a, n, n);
  DimVector(b, n);
  WriteLn(Length(a));
  WriteLn(Length(b));

  Randomize;
  // Генерация значений массива A
  WriteLn('Заполнение матрицы A...');
  for i:= 1 to n do 
  begin
    for j := 1 to n do
    begin
      A[i, j]:=Random;
    end;
  end;
  WriteLn('Готово!');
 
  // Генерация значений B
  WriteLn('Запонение вектора b...');
  for i:= 1 to n do
    b[i]:=random+1;
  WriteLn('Готово!');
  
  WriteLn('Вычисление...');
  t1:=Time;
  LinEq(A, b, 1, n, term);
  t2:=Time;
  WriteLn('Готово!');
  WriteLn('Время вычисления: ', Millisecondsbetween(t2, t1)/1000:10:3);
End.
