!********************************************************
! Вычисление числа PI по формуле Фабриса Беллара.
! Компилятор GFortran.
!
! Компиляция:
!	gfortran pi_bal.f90 -o pi_bal
!********************************************************
program pi_bal

real(16) :: pi_bellard = 0.0_16
real(16) :: m1, m2, m3, m4, m5, m6, m7, m8
real :: startt, endt
integer(8) :: k

call cpu_time(startt)

do k=0, 20000000_8
  m1 = (-1._16)**k/2._16**(10*k)

  m2 = -(2._16**5/(4._16*k + 1._16))
  m3 = 1._16/(4._16*k + 3._16)
  m4 = 2._16**8/(10._16*k + 1._16)
  m5 = 2._16**6/(10._16*k + 3._16)
  m6 = 2._16**2/(10._16*k + 5._16)
  m7 = 2._16**2/(10._16*k + 7._16)
  m8 = 1._16/(10._16*k + 9._16)

  pi_bellard = pi_bellard + m1 * (m2 - m3 + m4 - m5 - m6 - m7 + m8)
end do
pi_bellard = pi_bellard * (1._16/2._16**6)

call cpu_time(endt)

print *, pi_bellard
print *, 'Время: ', endt-startt, ' секунд'
print *, "  3,14159265358979323846264338327950288"

end program pi_bal
