unit PasZipUtilU;

{$Include PasZUtil.inc}

interface

uses
  Classes,
  zipper;

function CreateStream(const aFilePath: string; const aSubFilePath: String): TStream;

implementation

type

  { THelper }

  THelper = class
  public
    procedure CreateStream(
      aSender: TObject;
      var aStream: TStream;
      aItem: TFullZipFileEntry
    );
  public
    procedure DoneStream(
      aSender: TObject;
      var aStream: TStream;
      aItem: TFullZipFileEntry
    );
  public
    Result: TStream;
  end;

function CreateStream(const aFilePath: string; const aSubFilePath: String): TStream;
var
  h: THelper;
  z: TUnZipper;
  strings: TStrings;
begin
  z := TUnZipper.Create;
  z.FileName := aFilePath;
  h := THelper.Create;
  z.OnCreateStream := @h.CreateStream;
  z.OnDoneStream := @h.DoneStream;
  strings := TStringList.Create;
  strings.Add(aSubFilePath);
  z.UnZipFiles(strings);
  result := h.Result;
  strings.Free;
  h.Free;
  z.Free;
end;

{ THelper }

procedure THelper.CreateStream(
  aSender: TObject;
  var aStream: TStream;
  aItem: TFullZipFileEntry);
begin
  aStream := TMemoryStream.Create;
end;

procedure THelper.DoneStream(
  aSender: TObject;
  var aStream: TStream;
  aItem: TFullZipFileEntry
);
begin
  Result := aStream;
end;


end.

