unit PasZUtilU;

{$Include PasZUtil.inc}

interface

uses
  Classes, sysutils, zstream;

procedure CompressTransf(const aSource, aDest: TStream; aLevel: Tcompressionlevel);
procedure CompressTransf(const aSource, aDest: TStream);
procedure ReplaceWithCompressed(var a: TStream);
procedure DecompressTransf(const aSource, aDest: TStream);
procedure ReplaceWithDecompressed(var a: TStream);

implementation

type
  TypeOfSize = Int64;

procedure CompressTransf(const aSource, aDest: TStream; aLevel: Tcompressionlevel);
var
  c: Tcompressionstream;
  n: TypeOfSize;
begin
  c := Tcompressionstream.create(aLevel, aDest);
  n := aSource.Size;
  aDest.Write(n, SizeOf(n));
  c.CopyFrom(aSource, aSource.Size);
  c.Free;
end;

procedure CompressTransf(const aSource, aDest: TStream);
begin
  CompressTransf(aSource, aDest, cldefault);
end;

procedure ReplaceWithCompressed(var a: TStream);
var
  b: TMemoryStream;
begin
  a.Position := 0;
  b := TMemoryStream.Create;
  CompressTransf(a, b);
  a.Free;
  a := b;
end;

procedure DecompressTransf(const aSource, aDest: TStream);
var
  d: Tdecompressionstream;
  n: TypeOfSize;
begin
  n := 0;
  aSource.Read(n, SizeOf(n));
  d := Tdecompressionstream.create(aSource);
  aDest.CopyFrom(d, n);
  d.Free;
end;

procedure ReplaceWithDecompressed(var a: TStream);
var
  b: TMemoryStream;
begin
  a.Position := 0;
  b := TMemoryStream.Create;
  DecompressTransf(a, b);
  a.Free;
  a := b;
end;

end.

