unit StringLinkedListU;

{$Include PasStr.inc}

interface

uses
  types,
  sysutils,
  StringUtilU,
  StringBuilderU;

type
  PStringLinkedListItem = ^TStringLinkedListItem;
  TStringLinkedListItem = record
    Value: string;
    Next: PStringLinkedListItem;
  end;

  TStringLinkedListForEach = procedure(const s: string) is nested;

  { TStringLinkedList }

  TStringLinkedList = class
  public
    constructor Create;
  protected
    First: PStringLinkedListItem;
  protected
    Last: PStringLinkedListItem;
  protected
    procedure AddItem(item: PStringLinkedListItem);
  public
    procedure Add(const s: string);
  public
    procedure Add(s: TStringDynArray);
  public
    procedure ForEach(a: TStringLinkedListForEach);
  public
    procedure Clear;
  public
    function ToString(const aSeparator: string): string; overload;
  public
    procedure FromString(const s: string; aSeparator: Char);
  public
    destructor Destroy; override;
  end;

function NewStringLinkedListItem(const s: string): PStringLinkedListItem;

implementation

{ TStringLinkedList }

constructor TStringLinkedList.Create;
begin
  inherited Create;
end;

procedure TStringLinkedList.AddItem(item: PStringLinkedListItem);
begin
  if Last <> nil then
  begin
    Last^.Next := item;
    Last := Last^.Next;
  end
  else
  begin
    First := item;
    Last := item;
  end;
end;

procedure TStringLinkedList.Add(const s: string);
begin
  AddItem(NewStringLinkedListItem(s));
end;

procedure TStringLinkedList.Add(s: TStringDynArray);
var
  i: Integer;
begin
  for i := 0 to Length(s) - 1 do
    Add(s[i]);
end;

procedure TStringLinkedList.ForEach(a: TStringLinkedListForEach);
var
  current: PStringLinkedListItem;
begin
  current := First;
  while current <> nil do
  begin
    a(current^.Value);
    current := current^.Next;
  end;
end;

procedure TStringLinkedList.Clear;
var
  current, next: PStringLinkedListItem;
begin
  current := First;
  while current <> nil do
  begin
    next := current^.Next;
    Dispose(current);
    current := next;
  end;
end;

function TStringLinkedList.ToString(const aSeparator: string): string;
var
  current: PStringLinkedListItem;
  s: TStringBuilder;
begin
  s := TStringBuilder.Create;
  current := First;
  while current <> nil do
  begin
    s.Add(current^.Value);
    current := current^.Next;
    if current <> nil then
      s.Add(aSeparator);
  end;
  result := s.ToString;
  s.Free;
end;

procedure TStringLinkedList.FromString(const s: string; aSeparator: Char);
var
  a: TStringDynArray;
  item: string;
begin
  Clear;
  a := SplitString(s, aSeparator);
  Add(a);
end;

destructor TStringLinkedList.Destroy;
begin
  Clear;
  inherited Destroy;
end;

function NewStringLinkedListItem(const s: string): PStringLinkedListItem;
begin
  New(result);
  result^.Value := s;
  result^.Next := nil;
end;

end.

