program PJMatrixGenPro;

uses
  sysutils,
  DOM, XMLWrite,
  PJB_XMLMatrixArrayU;

const
  MatrixCount = 100;

procedure GenerateTestingData;
var
  i: Integer;
  width, height: Integer;
  matrix: TIntegerMatrix;
  matrixElement: TDOMElement;
  matrixListElement: TDOMElement;
  doc: TXMLDocument;
begin
  WriteLn('Now generating testing data...');
  doc := TXMLDocument.Create;
  matrixListElement := doc.CreateElement('matrixList');
  matrixListElement.AppendChild(CreateElement(doc, CreateRandomMatrix(3, 3, -100, 100)));
  width := 10;
  height := 10;
  for i := 0 to MatrixCount - 1 do
  begin
    WriteLn('Matrix #' + IntToStr(i) + '...');
    matrix := CreateRandomMatrix(width, height, -100000, 100000);
    matrixElement := CreateElement(doc, matrix);
    matrixListElement.AppendChild(matrixElement);
  end;
  matrixListElement.AppendChild(CreateElement(doc, CreateRandomMatrix(3, 3, -100, 100)));
  doc.AppendChild(matrixListElement);
  WriteXMLFile(doc, 'data.xml');
  doc.Free;
end;

begin
  Randomize;
  GenerateTestingData;
end.

