{ Pascal vs Java Benchmark library for Android

  Copyright (C) 2014 Alexander Savinykh "hinst", email: hinstance@yandex.ru

  This library is free software; you can redistribute it and/or modify it under the terms of the
  GNU Library General Public License as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you permission to link this
  library with independent modules to produce an executable, regardless of the license terms of
  these independent modules,and to copy and distribute the resulting executable under terms of
  your choice, provided that you also meet, for each linked independent module, the terms and
  conditions of the license of that module. An independent module is a module which is not derived
  from or based on this library. If you modify this library, you may extend this exception to your
  version of the library, but you are not obligated to do so. If you do not wish to do so, delete
  this exception statement from your version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
  the GNU Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License along with this
  library; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
}
library PJBenchPro;

uses
  sysutils,
  jni,
  AndroidLogUnit,
  StringUtilU,
  PJB_CommonU,
  PJB_JavaNativeFaceU,
  PJB_LogU,
  PJB_BenchU;

procedure SetPackagePath(aEnv: PJNIEnv; aThis: jobject; aJavaString: jstring); cdecl;
var
  isCopy: jboolean;
begin
  isCopy := 0;
  WriteLog(AsString(@isCopy));
  PackageFilePath := String(GlobalEnv^^.GetStringUTFChars(GlobalEnv, aJavaString, isCopy));
  WriteLog('Package path = "' + PackageFilePath + '"');
end;

procedure Test(aEnv: PJNIEnv; aThis: jobject); cdecl;
begin
  WriteLog('Now starting test..');
  PJB_BenchU.Test;
end;

procedure RegisterProcs;
begin
  RegisterProc('SetPackagePath', '(Ljava/lang/String;)V', @SetPackagePath);
  RegisterProc('Test', '()V', @Test);
end;

function JNI_OnLoad(aVm:PJavaVM; aReserved: pointer): jint; cdecl;
begin
  WriteLog('JNI_OnLoad');
  result := JNI_VERSION_1_6;
  RegisterProcs;
  Load(aVm, aReserved);
end;

procedure JNI_OnUnload(vm:PJavaVM;reserved:pointer); cdecl;
begin
  Unload(vm, reserved);
end;

exports
  JNI_OnLoad, JNI_OnUnload;

initialization
  WriteLog('FPC Dynamic library initialization');
finalization
  WriteLog('FPC Dynamic library finalization');
end.

