{ Pascal vs Java benchmark XML matrix array unit

  Copyright (C) <year> <name of author> <contact>

  This library is free software; you can redistribute it and/or modify it under the terms of the
  GNU Library General Public License as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you permission to link this
  library with independent modules to produce an executable, regardless of the license terms of
  these independent modules,and to copy and distribute the resulting executable under terms of
  your choice, provided that you also meet, for each linked independent module, the terms and
  conditions of the license of that module. An independent module is a module which is not derived
  from or based on this library. If you modify this library, you may extend this exception to your
  version of the library, but you are not obligated to do so. If you do not wish to do so, delete
  this exception statement from your version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
  the GNU Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License along with this
  library; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
}


unit PJB_XMLMatrixArrayU;

interface

uses
  sysutils, DOM, XMLWrite;

type
  TIntegerMatrix = array of array of Integer;

function CreateRandomMatrix(aWidth, aHeight, a, b: Integer): TIntegerMatrix;
procedure WriteToStdOutput(a: TIntegerMatrix);
function CreateElement(aDocument: TXMLDocument; a: TIntegerMatrix): TDOMElement;
function CreateDocument(a: TIntegerMatrix): TXMLDocument;
procedure SaveToFile(a: TIntegerMatrix; const aFilePath: string);

implementation

function CreateRandomMatrix(aWidth, aHeight, a, b: Integer): TIntegerMatrix;
var
  x, y: Integer;
begin
  SetLength(result, aWidth);
  for x := 0 to aWidth - 1 do
  begin
    SetLength(result[x], aHeight);
    for y := 0 to aHeight - 1 do
      result[x, y] := Random(b - a + 1) + a;
  end;
end;

procedure WriteToStdOutput(a: TIntegerMatrix);
var
  x, y: Integer;
begin
  if Length(a) > 0 then
    for y := 0 to Length(a[0]) - 1 do
    begin
      for x := 0 to Length(a) - 1 do
        Write(a[x, y], ' ');
      WriteLN;
    end
  else
    WriteLN('Empty matrix');
end;

function CreateElement(aDocument: TXMLDocument; a: TIntegerMatrix): TDOMElement;
var
  x, y, width, height: Integer;
  column, cell: TDOMElement;
begin
  result := aDocument.CreateElement('matrix');
  width := Length(a);
  if width <> 0 then
    height := Length(a[0])
  else
    height := 0;
  result.SetAttribute('height', IntToStr(height));
  result.SetAttribute('width', IntToStr(width));
  for x := 0 to Length(a) - 1 do
  begin
    column := aDocument.CreateElement('column');
    for y := 0 to Length(a[x]) - 1 do
    begin
      cell := aDocument.CreateElement('cell');
      cell.TextContent := IntToStr(a[x, y]);
      column.AppendChild(cell);
    end;
    result.AppendChild(column);
  end;
end;

function CreateDocument(a: TIntegerMatrix): TXMLDocument;
begin
  result := TXMLDocument.Create;
  result.AppendChild(CreateElement(result, a));
end;

procedure SaveToFile(a: TIntegerMatrix; const aFilePath: string);
var
  doc: TXMLDocument;
begin
  doc := CreateDocument(a);
  WriteXMLFile(doc, aFilePath);
  doc.Free;
end;

end.

