unit PJB_LogU;

interface

uses
  AndroidLogUnit,
  PJB_CommonU;

const
  LogFilePath = '/mnt/sdcard/fpc.log.txt';

procedure WriteLog(const s: string);

implementation

var
  GlobalLogFile: TextFile;

procedure WriteLog(const s: string);
begin
  LOGI(ANDROID_LOG_INFO, Tag, PChar(s));
  WriteLn(GlobalLogFile, s);
  Flush(GlobalLogFile);
end;

initialization
  AssignFile(GlobalLogFile, LogFilePath);
  Rewrite(GlobalLogFile);
finalization
  CloseFile(GlobalLogFile);
end.

