unit PJB_JavaNativeFaceU;

interface

uses
  SysUtils, Classes, jni,
  AndroidLogUnit,
  PJB_LogU;

procedure Load(aVm : PJavaVM; aReserved : Pointer); cdecl;
procedure Unload(aVm : PJavaVM; aReserved : Pointer); cdecl;

procedure RegisterProc(const aName, aSign: PChar; const aPtr: Pointer);

var
  GlobalVM: PJavaVM;
var
  GlobalEnv: PJNIEnv;
var
  GlobalMethodList: TFPList;

implementation

function CreateMethodArray(const aList: TFPList): PJNINativeMethod;
var
  i: Integer;
begin
  result := GetMem(aList.Count * sizeOf(JNINativeMethod));
  for i := 0 to aList.Count - 1 do
    result[i] := PJNINativeMethod(aList[i])^;
end;

procedure WriteLogMethodArray(const a: PJNINativeMethod; const aCount: Integer);
var
  i: Integer;
  method: JNINativeMethod;
begin
  for i := 0 to aCount - 1 do
  begin
    method := a[i];
  end;
end;

procedure ReleaseMethodArray(const a: PJNINativeMethod);
begin
  FreeMem(a);
end;

procedure Load(aVm : PJavaVM; aReserved : Pointer); cdecl;
var
  zenGLClass: jclass;
  methods: PJNINativeMethod;
  methodCount: Integer;
  i: Integer;
begin
  GlobalVM := aVm;
  aVm^^.GetEnv(GlobalVM, @GlobalEnv, JNI_VERSION_1_6);
  zenGLClass := GlobalEnv^^.FindClass(GlobalEnv, 'hinst/pjbench/MainActivity');
  WriteLog('Class found: ' + BoolToStr(zenGLClass <> nil, True));
  methods := CreateMethodArray(GlobalMethodList);
  methodCount := GlobalMethodList.Count;
  WriteLog('Now registering methods: ' + IntToStr(methodCount));
  i := GlobalEnv^^.RegisterNatives(
    GlobalEnv, zenGLClass,
    methods, methodCount
  );
  WriteLog('Register natives success: ' + BoolToStr(i = 0, True));
  ReleaseMethodArray(methods);
end;

procedure Unload(aVm: PJavaVM; aReserved: Pointer); cdecl;
begin
end;

procedure RegisterProc(const aName, aSign: PChar; const aPtr: Pointer
  );
var
  method: PJNINativeMethod;
begin
  New(method);
  method^.name := aName;
  method^.signature := aSign;
  method^.fnPtr := aPtr;
  GlobalMethodList.Add(method);
end;

procedure ReleaseJNINativeMethodList;
var
  p: Pointer;
begin
  for p in GlobalMethodList do
    Dispose(PJNINativeMethod(p));
  GlobalMethodList.Free;
end;

initialization
  GlobalMethodList := TFPList.Create;
finalization
  ReleaseJNINativeMethodList;
end.

