{ Pascal vs Java benchmark 'Bench' unit for Android

  Copyright (C) 2014 Alexander Savinykh "hinst" email: hinstance@yandex.ru

  This library is free software; you can redistribute it and/or modify it under the terms of the
  GNU Library General Public License as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you permission to link this
  library with independent modules to produce an executable, regardless of the license terms of
  these independent modules,and to copy and distribute the resulting executable under terms of
  your choice, provided that you also meet, for each linked independent module, the terms and
  conditions of the license of that module. An independent module is a module which is not derived
  from or based on this library. If you modify this library, you may extend this exception to your
  version of the library, but you are not obligated to do so. If you do not wish to do so, delete
  this exception statement from your version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
  the GNU Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License along with this
  library; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
}


unit PJB_BenchU;

interface

uses
  sysutils,
  Classes,
  zipper,
  XMLWrite,
  EpikTimer,
  DOM, XMLRead,
  PasZipUtilU,
  PJB_CommonU,
  PJB_LogU,
  PJB_TimerU,
  PJB_XMLMatrixArrayU;

type
  TIntegerMatrix = array of array of Integer;
  TIntegerMatrixArray = array of TIntegerMatrix;

procedure Test;

implementation

function LoadMatrixArray(const aDoc: TXMLDocument): TIntegerMatrixArray;
var
  timer: TimerData;
  node: TDOMNode;
  width, height: Integer;
  matrix: TIntegerMatrix;
  x, y, i: Integer;
begin
  ClearStart(timer);
  SetLength(result, aDoc.FirstChild.ChildNodes.Count);
  node := aDoc.FirstChild.FirstChild;
  i := 0;
  while node <> nil do
  begin
    width := StrToInt(node.Attributes.GetNamedItem('width').TextContent);
    height := StrToInt(node.Attributes.GetNamedItem('height').TextContent);
    SetLength(matrix, width, height);
    for x := 0 to width - 1 do
      for y := 0 to height - 1 do
        matrix[x, y] := StrToInt(node.ChildNodes[x].ChildNodes[y].TextContent);
    node := node.NextSibling;
    result[i] := matrix;
    Inc(i);
  end;
  Stop(timer);
  WriteLog('Load matrix list from xml: time spent: ' + GetElapsedStr(timer));
end;

function Load: TIntegerMatrixArray;
var
  stream: TStream;
  t: TimerData;
  doc: TXMLDocument;
begin
  WriteLog('Now unpacking data...');
  ClearStart(t);
  stream :=  CreateStream(PackageFilePath, 'assets/data.xml');
  Stop(t);
  WriteLog('Got data: ' + IntToStr(stream.Size) + ' bytes; time spend: ' + GetElapsedStr(t));
  ClearStart(t);
  stream.Position := 0;
  ReadXMLFile(doc, stream);
  stream.Free;
  WriteLog('Pharsed XML data; time spent: ' + GetElapsedStr(t));
  WriteLog('Matrices in list: ' + IntToStr(doc.FirstChild.ChildNodes.Count) + ' items');
  result := LoadMatrixArray(doc);
  doc.Free;
end;

function prodSM(const a, b: TIntegerMatrix): TIntegerMatrix;
var
  x, y, w: Integer;
  c: TIntegerMatrix;
  cellValue, r: Integer;
begin
  w := Length(a);
  SetLength(c, w, w);
  for x := 0 to w - 1 do
  begin
    for y := 0 to w - 1 do
    begin
      cellValue := 0;
      for r := 0 to w - 1 do
        cellValue := cellValue + a[r, y] * b[x, r];
      c[x, y] := cellValue;
    end;
  end;
  result := c;
end;

function Bench(const a: TIntegerMatrixArray): TIntegerMatrixArray;
var
  n, i, w: Integer;
  time: TimerData;
begin
  ClearStart(time);
  n := Length(a);
  SetLength(result, n);
  for i := 0 to n - 1 do
    result[i] := prodSM(a[i], a[n - i - 1]);
  Stop(time);
  WriteLog('matrix products calculated; time spent: ' + GetElapsedStr(time) + ' secs');
end;

procedure EmptyCycleBench;
var
  i, j: Integer;
  time: TimerData;
begin
  ClearStart(time);
  for i := 0 to 100000000 do
    ;
  Stop(time);
  WriteLog('empty cycle; time spent: ' + GetElapsedStr(time) + ' secs');
end;

function CreateDocument(const a: TIntegerMatrixArray): TXMLDocument;
var
  i: Integer;
  matrixList: TDOMElement;
begin
  result := TXMLDocument.Create;
  matrixList := result.CreateElement('matrixList');
  for i := 0 to Length(a) - 1 do
  begin
    matrixList.AppendChild(CreateElement(result, a[i]));
  end;
  result.AppendChild(matrixList);
end;

procedure Save(const a: TIntegerMatrixArray; const aFilePath: string);
var
  doc: TXMLDocument;
  time: TimerData;
begin
  ClearStart(time);
  doc := CreateDocument(a);
  Stop(time);
  WriteLog('Save matrix array to xml document: ' + GetElapsedStr(time) + ' seconds');
  ClearStart(time);
  WriteXML(doc, aFilePath);
  Stop(time);
  WriteLog('Save xml document to file: ' + GetElapsedStr(time) + ' seconds');
  doc.Free;
end;

procedure Test;
var
  mArray, rArray: TIntegerMatrixArray;
begin
  mArray := Load;
  rArray := Bench(mArray);
  Save(rArray, '/mnt/sdcard/r.fpc.txt');
  EmptyCycleBench;
end;

end.

