unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, sqlite3conn, sqldb, FileUtil, LResources, Forms, Controls,
  Graphics, Dialogs, ExtCtrls, ComCtrls, Buttons, songs;

type

  TDirQuery = (dqPrev, dqCurr, dqNext);
  { TForm1 }

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ListView1: TListView;
    Panel1: TPanel;
    SQLite3Connection1: TSQLite3Connection;
    SQLQuery1: TSQLQuery;
    SQLTransaction1: TSQLTransaction;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { private declarations }
    FSongs: TSongs;
    FAllRecords: Integer;
    procedure GetCurrentPage(Dir: TDirQuery);
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

Const
  cPageSize = 100;
{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  //Создаем коллекцию
  FSongs:=TSongs.Create(TSong);

  //Определяем общее количество записей
  SQLQuery1.SQL.Clear;
  SQLQuery1.SQL.Text:='SELECT COUNT(*) FROM rus';
  SQLQuery1.Open;
  FAllRecords:=SQLQuery1.Fields[0].AsInteger;
  SQLQuery1.Close;

  //Основной запрос
  SQLQuery1.SQL.Clear;
  SQLQuery1.SQL.Add('SELECT rus.id, sol.name, rus.name');
  SQLQuery1.SQL.Add('FROM rus INNER JOIN sol');
  SQLQuery1.SQL.Add('ON rus.sol_id=sol.id');
  SQLQuery1.SQL.Add('ORDER BY sol.name, rus.name');
  SQLQuery1.SQL.Add('LIMIT '+IntToStr(cPageSize)+' OFFSET :n');

  SQLQuery1.Params[0].AsInteger:=0;
  SQLQuery1.Open;
  GetCurrentPage(dqCurr);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FSongs.Free;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  GetCurrentPage(dqPrev);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  GetCurrentPage(dqNext);
end;

procedure TForm1.GetCurrentPage(Dir: TDirQuery);
Var
  i: Integer;
begin
  //В зависимости от параметра процедуры определяем с какого номера записи проводить выборку
  Case Dir of
    dqPrev: If SQLQuery1.Params[0].AsInteger>=cPageSize Then
              SQLQuery1.Params[0].AsInteger:=SQLQuery1.Params[0].AsInteger-cPageSize;
    dqNext: If SQLQuery1.Params[0].AsInteger<=FAllRecords-cPageSize Then
              SQLQuery1.Params[0].AsInteger:=SQLQuery1.Params[0].AsInteger+cPageSize;
  End;

  SQLQuery1.Close;
  SQLQuery1.Open;

  //Заполняем коллекцию
  FSongs.Clear;
  While not SQLQuery1.Eof Do
  Begin
    With FSongs.Add Do
    Begin
      Id := SQLQuery1.Fields[0].AsString;
      Solist := SQLQuery1.Fields[1].AsString;
      SongName := SQLQuery1.Fields[2].AsString;
    End;
    SQLQuery1.Next;
 End;

  //Заполняем полученой порцией данных компонент отображения
  ListView1.Items.Clear;
  For i:=0 To FSongs.Count-1 Do
  Begin
    ListView1.Items.Add;
    ListView1.Items[i].Caption:=FSongs[i].Id;
    ListView1.Items[i].SubItems.Add(FSongs[i].Solist);
    ListView1.Items[i].SubItems.Add(FSongs[i].SongName);
  End;
end;


initialization
  {$I unit1.lrs}

end.

