unit unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, Menus,
  StdCtrls, Buttons, unix, ExtCtrls, Ipfilebroker, Process;

const
mem_file = 'conf';



type
  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    OpenDialog1: TOpenDialog;
    SelectDirectoryDialog1: TSelectDirectoryDialog;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private

  public
    { public declarations }
  end; 

var
  Form1: TForm1; 
  current_dir:string;//путь к каталогу запуска программы

implementation

uses
    unit2,unit3;

{ TForm1 }

procedure TForm1.MenuItem1Click(Sender: TObject);
begin

end;

procedure TForm1.MenuItem2Click(Sender: TObject);
begin
  Close();
end;

procedure TForm1.MenuItem4Click(Sender: TObject);
begin
  helpForm := ThelpForm.Create(owner);
  helpform.Show;
end;

procedure TForm1.MenuItem5Click(Sender: TObject);
begin
  form2 := Tform2.Create(owner);
  form2.Show;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  label3.Caption:='';
  timer1.Enabled:=false;
end;



procedure TForm1.Button3Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
  Edit1.Text := OpenDialog1.FileName;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  ss:string;
  err,a:integer;
  pm:TStringList;
begin
  ss:='mount -o loop '+ '"'+edit1.Text+ '"' + ' ' + '"'+edit2.text+ '"';
     a:=shell(ss);
     case a of
     0:label3.Text:='Образ диска успешно примонтирован';
     1:label3.Text:='Не хватает прав для монтирования, запустите программу через sudo';
     32:label3.Text:='Нет такого файла или каталога, или файл не является образом диска';
     else
     label3.Text:='Какая то ошибка при монтировании';
     end;

//создаем экземпляр списочной переменной
pm:=TStringList.Create;
pm.LoadFromFile(current_dir+'/'+mem_file);
pm.strings[0]:=edit1.Text;
pm.strings[1]:=edit2.Text;
pm.SaveToFile(current_dir+'/'+mem_file);
pm.Free;
timer1.Enabled:=true;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  ss:string;
  pm:TStringList;
  a:integer;
begin
  ss:='umount '+ '"'+ edit2.text+ '"';
     a:=shell(ss);
     case a of
     0:label3.Text:='Образ диска успешно отмонтирован';
     else
     label3.Text:='Не удалось отмонтировать ресурс';
     end;

     
//создаем экземпляр списочной переменной
pm:=TStringList.Create;
pm.LoadFromFile(current_dir+'/'+mem_file);
pm.strings[0]:=edit1.Text;
pm.strings[1]:=edit2.Text;
pm.SaveToFile(current_dir+'/'+mem_file);
pm.Free;
timer1.Enabled:=true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if SelectDirectoryDialog1.Execute then
  begin
  Edit2.Text := SelectDirectoryDialog1.FileName;
  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  close();
end;



procedure TForm1.FormCreate(Sender: TObject);
var
   pm:TStringList;
   ss:string;
   i:integer;
begin
  //получаем путь к каталогу с программой
  current_dir:=GetAppConfigDir(false);

  //создаем экземпляр списочной переменной
  pm:=TStringList.Create;
  try //если файл не существует
  pm.LoadFromFile(current_dir+'/'+mem_file);//попытка открыть файл
  except //то создаем файл со значениями по умолчанию
  pm.Add('');
  pm.Add('');
  CreateDir(current_dir);
  pm.SaveToFile(current_dir+'/'+mem_file);
  end;

ss:=pm.Strings[0];
edit2.Text:=pm.Strings[1];
edit1.Text:=ss;

  for i:= Length(ss) downto 1 do
      begin
      if ss[i]='/' then break;
      end;
  Delete(ss,i,Length(ss)+1-i);
  openDialog1.initialdir:=ss;


SelectDirectoryDialog1.InitialDir:=pm.Strings[1];
pm.Free;
end;



initialization
  {$I unit1.lrs}

end.

