uses x,xlib,xutil,crt,dos;

(*
 create_simple_window -       .
     ,   ( )
    (  ).   .
        2   
   .
*)
function create_simple_window(display : PDisplay;
              width, height, x, y : integer): TWindow;
var
  screen_num, win_border_width: integer;
  win: TWindow;
begin
 screen_num := XDefaultScreen(display);
 win_border_width := 2;
 
(*
         ,
          , 
          
*)
 win := XCreateSimpleWindow(display, XRootWindow(display, screen_num),
              x, y, width, height, win_border_width,
              XBlackPixel(display, screen_num),
              XWhitePixel(display, screen_num));

 (*    . *)
 XMapWindow(display, win);

 (*       . *)
 XFlush(display);

 create_simple_window:=win;
end;


//void main(int argc, char* argv[])
var
 display: PDisplay; (*      *)
 screen_num: integer; (*      *)
 win: TWindow; (*    *)
 display_width, display_height: word; (*      *)
 win_width, win_height: word; (*      *)
 display_name: array [0..30] of Char;
 name: string;
 i: integer;
 win_attr: TXWindowAttributes;
 xx, y, scr_x, scr_y: integer;
 child_win: TWindow;
 (*       *)
 parent_win: TWindow;
 (*        *)
 (* ,      *)
 root_win: TWindow;
 (*       *)
 (*    , *)
 child_windows: PWindow;
 (*   -   *)
 num_child_windows: integer;

begin
 name := getenv('DISPLAY'); (*    *)
 for i:=1 to byte(name[0]) do
   display_name[i-1]:=name[i];
 display_name[byte(name[0])]:=#0;
 (*      *)
 display := XOpenDisplay(display_name);
 if (display = NIL) then begin
  writeln(paramstr(0),':       ',
      display_name);
  halt(1);
 end;

 (*         *)
 screen_num := XDefaultScreen(display);
 display_width := XDisplayWidth(display, screen_num);
 display_height := XDisplayHeight(display, screen_num);

 (*     1/9   *)
 win_width := (display_width div 3);
 win_height := (display_height div 3);
 (*      *)
 writeln('  - ', win_width, ';  - ', win_height);

 (*         ,  *)
 (*          , *)
 (*           *)
 win := create_simple_window(display, win_width, win_height, 0, 0);

 XFlush(display);

 (*     *)
 delay(3000);

 (*     *)
 begin

  (*     *)
  for i:=0 to 39 do begin
   dec(win_width,3);
   dec(win_height,3);
   XResizeWindow(display, win, win_width, win_height);
   XFlush(display);
   delay(20);
  end;

  (*     *)
  for i:=0 to 39 do begin
   inc(win_width,3);
   inc(win_height,3);
   XResizeWindow(display, win, win_width, win_height);
   XFlush(display);
   delay(20);
  end;
 end;

 delay(1000);

 (*    *)
 begin

  (*      *)
  XGetWindowAttributes(display, win, @win_attr);

  xx := win_attr.x;
  y := win_attr.y;

  (*     *)
  begin

   (*     *)
   XQueryTree(display, win,
         @root_win,
         @parent_win,
         @child_windows, @num_child_windows);

   (*      , *)
   (*       XQueryTree()  *)
   XFree(child_windows);
  end;

  (*     ,   *)
  (*    ,    *)
  (* .   ,     *)
  (*  ,        *)
  (*                    *)
  XTranslateCoordinates(display,
             parent_win, win_attr.root,
             xx, y,
             @scr_x, @scr_y,
             @child_win);

  (*    *)
  for i:=0 to 39 do begin
   dec(scr_x,3);
   XMoveWindow(display, win, scr_x, scr_y);
   XFlush(display);
   delay(20);
  end;

  (*    *)
  for i:=0 to 39 do  begin
   inc(scr_y,3);
   XMoveWindow(display, win, scr_x, scr_y);
   XFlush(display);
   delay(20);
  end;

  (*    *)
  for i:=0 to 39 do  begin
   inc(scr_x,3);
   XMoveWindow(display, win, scr_x, scr_y);
   XFlush(display);
   delay(20);
  end;

  (*    *)
  for i:=0 to 39 do  begin
   dec(scr_y,3);
   XMoveWindow(display, win, scr_x, scr_y);
   XFlush(display);
   delay(20);
  end;
 end;

 delay(1000);

 (*      *)
 begin
  (*   *)
  XIconifyWindow(display, win, XDefaultScreen(display));
  XFlush(display);
  delay(2000);
  (*   *)
  XMapWindow(display, win);
  XFlush(display);
  delay(2000);
 end;

 XFlush(display);

 (*   *)
 delay(2000);

 (*      *)
 XCloseDisplay(display);
end.
