uses x,xlib,x11,xutil,strings;

const
     WND_X=0;
     WND_Y=0;
     WND_WDT=100;
     WND_HGH=100;
     WND_MIN_WDT=50;
     WND_MIN_HGH=50;
     WND_BORDER_WDT=5;
     WND_TITLE='Hello!';
     WND_ICON_TITLE='Hello!';
     PRG_CLASS='Hello!';

(*
* SetWindowManagerHints -    
*    .
*)

procedure SetWindowManagerHints (
 prDisplay : PDisplay; (*   Display *)
 psPrgClass : PChar; (*  *)
 argv : PPChar;   (*  *)
 argc : integer;    (*  *)
 nWnd : TWindow;    (*  *)
         x,     (*   *)
         y,     (*  *)
         nWidth,
         nHeight,  (*    *)
         nMinWidth,
         nMinHeight:integer; (*     *)
 psTitle     : PChar;  (*  *)
 psIconTitle : PChar;    (*   *)
 nIconPixmap : TPixmap    (*  *)
);
var
 rSizeHints : TXSizeHints ; (*   *)
 rWMHints : TXWMHints ;
 rClassHint : TXClassHint ;
 prWindowName, prIconName : TXTextProperty ;
begin

 if ( XStringListToTextProperty (@psTitle, 1, @prWindowName )=0) or
    (XStringListToTextProperty (@psIconTitle, 1, @prIconName )=0 ) then
 begin
  writeln('No memory!');
  halt(1);
 end;

rSizeHints.flags := PPosition OR PSize OR PMinSize;
rSizeHints.min_width := nMinWidth;
rSizeHints.min_height := nMinHeight;
rWMHints.flags := StateHint OR IconPixmapHint OR InputHint;
rWMHints.initial_state := NormalState;
rWMHints.input := True;
rWMHints.icon_pixmap := nIconPixmap;

rClassHint.res_name := argv[0];
rClassHint.res_class := psPrgClass;

XSetWMProperties ( prDisplay, nWnd, @prWindowName,
  @prIconName, argv, argc, @rSizeHints, @rWMHints,
  @rClassHint );
end;

(*
*main -   
*)

//void main(int argc, char *argv[])
var
 prDisplay: PDisplay;  (*    Display *)
 nScreenNum: integer;    (*   *)
 prGC: TGC;
 rEvent: TXEvent;
 nWnd: TWindow;
begin

 (*     *)
 prDisplay := XOpenDisplay ( nil );
 if prDisplay = nil  then begin
  writeln('Can not connect to the X server!');
  halt ( 1 );
 end;

 (*     *)
 nScreenNum := XDefaultScreen ( prDisplay );

 (*   *)
 nWnd := XCreateSimpleWindow ( prDisplay,
     XRootWindow ( prDisplay, nScreenNum ),
     WND_X, WND_Y, WND_WDT, WND_HGH, WND_BORDER_WDT,
     XBlackPixel ( prDisplay, nScreenNum ),
     XWhitePixel ( prDisplay, nScreenNum ) );

 (*      *)
 SetWindowManagerHints ( prDisplay, PRG_CLASS, argv, argc,
   nWnd, WND_X, WND_Y, WND_WDT, WND_HGH, WND_MIN_WDT,
   WND_MIN_HGH, WND_TITLE, WND_ICON_TITLE, 0 );

 (*  ,   *)
 XSelectInput ( prDisplay, nWnd, ExposureMask OR KeyPressMask );

 (*   *)
 XMapWindow ( prDisplay, nWnd );

 (*      *)
 while ( true ) do begin
  XNextEvent ( prDisplay, @rEvent );

  case ( rEvent.eventtype ) of
    Expose :
    begin
     (*    *)
     if ( rEvent.xexpose.count <> 0 ) then
      continue;

     prGC := XCreateGC ( prDisplay, nWnd, 0 , nil );

     XSetForeground ( prDisplay, prGC,
       XBlackPixel ( prDisplay, 0) );
     XDrawString ( prDisplay, nWnd, prGC, 10, 50,
       'Hello, world!', strlen ( 'Hello, world!' ) );
     XFreeGC ( prDisplay, prGC );
    end;

    KeyPress :
    begin
     (*    *)
     XCloseDisplay ( prDisplay );
     halt ( 0 );
    end;
  end;
 end;
end.
