{$MODE OBJFPC}

unit StdWindow;

interface

uses
  Windows;

const
  CN_MAIN = 'our_main_window';

implementation

const
  ID_CHECKBOX_1 = $101;
  ID_CHECKBOX_2 = $102;
  ID_CHECKBOX_3 = $103;

  ID_RADIOBUTTON_1 = $104;
  ID_RADIOBUTTON_2 = $105;
  ID_RADIOBUTTON_3 = $106;
  ID_RADIOBUTTON_4 = $107;
  ID_RADIOBUTTON_5 = $108;

  ID_EDIT_1 = $109;
  ID_EDIT_2 = $10A;

  ID_STATIC_1 = $10B;
  ID_STATIC_2 = $10C;

const
  cbStates : array [0..2] of pchar =
             ('BST_UNCHECKED',
              'BST_CHECKED',
              'BST_INDETERMINATE');

procedure ProcessCreate (Wnd : HWnd);
 var
   ctl : HWnd;
   lF : TLogFont;
   hF : HFont;
 begin
 SystemParametersInfo (SPI_GETICONTITLELOGFONT, 0, @lF, 0);
 hF := CreateFontIndirect (@lf);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        '',
        WS_CHILD or WS_VISIBLE or BS_AUTOCHECKBOX,
        10, 10,
        150, 20,
        Wnd,
        ID_CHECKBOX_1,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        '   ',
        WS_CHILD or WS_VISIBLE or BS_AUTO3STATE,
        10, 30,
        300, 20,
        Wnd,
        ID_CHECKBOX_2,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' - "" ',
        WS_CHILD or WS_VISIBLE or BS_AUTO3STATE or BS_PUSHLIKE,
        10, 50,
        300, 20,
        Wnd,
        ID_CHECKBOX_3,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);

 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' 1 -  1',
        WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON or WS_GROUP,
        10, 80,
        300, 20,
        Wnd,
        ID_RADIOBUTTON_1,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' 1 -  2',
        WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,
        10, 100,
        300, 20,
        Wnd,
        ID_RADIOBUTTON_2,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' 1 -  3',
        WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,
        10, 120,
        300, 20,
        Wnd,
        ID_RADIOBUTTON_3,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);

 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' 2 -  1',
        WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON or BS_PUSHLIKE or WS_GROUP,
        10, 150,
        300, 20,
        Wnd,
        ID_RADIOBUTTON_4,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        0,
        'BUTTON',
        ' 2 -  2',
        WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON or BS_PUSHLIKE,
        10, 170,
        300, 20,
        Wnd,
        ID_RADIOBUTTON_5,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);

 ctl := CreateWindowEx (
        WS_EX_CLIENTEDGE,
        'EDIT',
        ' ',
        WS_CHILD or WS_VISIBLE or ES_AUTOHSCROLL,
        10, 200,
        300, 20,
        Wnd,
        ID_EDIT_1,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 ctl := CreateWindowEx (
        WS_EX_CLIENTEDGE,
        'EDIT',
        ''+#13#10+' ',
        WS_CHILD or WS_VISIBLE
                 or ES_MULTILINE or ES_AUTOHSCROLL or ES_AUTOVSCROLL
                 or ES_WANTRETURN or WS_HSCROLL or WS_VSCROLL,
        10, 220,
        300, 80,
        Wnd,
        ID_EDIT_2,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);

 ctl := CreateWindowEx (
        WS_EX_CLIENTEDGE,
        'STATIC',
        ''+#13#10+' ',
        WS_CHILD or WS_VISIBLE
                 or SS_LEFT,
        10, 310,
        260, 40,
        Wnd,
        ID_STATIC_1,
        HInstance,
        nil
        );
 SendMessage (ctl, WM_SETFONT, hF, 0);

 ctl := CreateWindowEx (
        0,
        'STATIC',
        nil,
        WS_CHILD or WS_VISIBLE
                 or SS_ICON,
        274, 310,
        32, 32,
        Wnd,
        ID_STATIC_2,
        HInstance,
        nil
        );
 SendMessage (ctl, STM_SETIMAGE, IMAGE_ICON, LoadIcon (0, IDI_ASTERISK))
 end;

procedure ProcessCommand (Wnd : HWnd; Cmd : word; Ctl : HWnd);
 var
   edt, stc : HWnd;
   len : dword;
   str : pchar;
 begin
 case Cmd of
      ID_CHECKBOX_1 : MessageBox (Wnd, cbStates[SendMessage(Ctl, BM_GETCHECK, 0, 0)], '', MB_ICONASTERISK);
      ID_CHECKBOX_2 : MessageBox (Wnd, cbStates[SendMessage(Ctl, BM_GETCHECK, 0, 0)], '   ', MB_ICONASTERISK);
      ID_CHECKBOX_3 : MessageBox (Wnd, cbStates[SendMessage(Ctl, BM_GETCHECK, 0, 0)], ' - "" ', MB_ICONASTERISK);
      ID_RADIOBUTTON_4 : begin
                         edt := GetDlgItem (Wnd, ID_EDIT_1);
                         len := SendMessage (edt, WM_GETTEXTLENGTH, 0, 0);
                         getMem (str, len + 1);
                         SendMessage (edt, WM_GETTEXT, len + 1, longint(str));
                         stc := GetDlgItem (Wnd, ID_STATIC_1);
                         SendMessage (stc, WM_SETTEXT, 0, longint(str));
                         freeMem (str)
                         end;
      ID_RADIOBUTTON_5 : begin
                         edt := GetDlgItem (Wnd, ID_EDIT_2);
                         len := SendMessage (edt, WM_GETTEXTLENGTH, 0, 0);
                         getMem (str, len + 1);
                         SendMessage (edt, WM_GETTEXT, len + 1, longint(str));
                         stc := GetDlgItem (Wnd, ID_STATIC_1);
                         SendMessage (stc, WM_SETTEXT, 0, longint(str));
                         freeMem (str)
                         end;
      end;
 end;

function WndProc (
         Wnd : HWnd;
         Msg : cardinal;
         wParam, lParam : longint
         ) : longint; stdcall;
 begin
 result := 0;
 case Msg of
      WM_COMMAND : ProcessCommand (Wnd, loword(wParam), lParam);
      WM_CREATE : ProcessCreate (Wnd);
      WM_DESTROY : PostQuitMessage (0)
      else result := DefWindowProc (Wnd, Msg, wParam, lParam)
      end
 end;

var
  WndClass : PWndClassEx;

initialization
WndClass := new(PWndClassEx);
WndClass^.cbSize := sizeof(TWndClassEx);
WndClass^.style := CS_DBLCLKS or CS_HREDRAW or CS_OWNDC or CS_VREDRAW;
WndClass^.lpfnWndProc := @WndProc;
WndClass^.cbClsExtra := 0;
WndClass^.cbWndExtra := 0;
WndClass^.hInstance := HInstance;
WndClass^.hIcon := LoadIcon (0, IDI_ASTERISK);
WndClass^.hCursor := LoadCursor (0, IDC_ARROW);
WndClass^.hbrBackground := COLOR_BTNFACE + 1;
WndClass^.lpszMenuName := nil;
WndClass^.lpszClassName := CN_MAIN;
WndClass^.hIconSm := 0;
if RegisterClassEx (WndClass^) = 0
   then begin
        MessageBox (0, '  !', '!', MB_ICONSTOP);
        Halt (1)
        end;
dispose(WndClass)
end.
