{$MODE OBJFPC}

unit ListsWindow;

interface

uses
  Windows,
  SysUtils;

const
  CN_MAIN = 'our_main_window';

implementation

const
  ID_LISTBOX_SINGLE = $101;
  ID_LISTBOX_MULTI  = $102;
  
  ID_COMBO_DROPDOWN = $103;
  ID_COMBO_DROPDOWNLIST = $104;

procedure ProcessCreate (Wnd : HWnd);
 var
   ctl : HWnd;
   lF : TLogFont;
   hF : HFont;
 begin
 SystemParametersInfo (SPI_GETICONTITLELOGFONT, 0, @lF, 0);
 hF := CreateFontIndirect (@lf);
 ctl := CreateWindowEx (WS_EX_CLIENTEDGE,
                        'LISTBOX',
                        '',
                        WS_CHILD or WS_VISIBLE or WS_VSCROLL or
                        LBS_HASSTRINGS or LBS_NOTIFY,
                        10,10,
                        135,100,
                        Wnd,
                        ID_LISTBOX_SINGLE,
                        HInstance,
                        nil
                        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));

 ctl := CreateWindowEx (WS_EX_CLIENTEDGE,
                        'LISTBOX',
                        '',
                        WS_CHILD or WS_VISIBLE or WS_VSCROLL or
                        LBS_HASSTRINGS or LBS_EXTENDEDSEL {or LBS_MULTIPLESEL} or LBS_NOTIFY,
                        150,10,
                        135,100,
                        Wnd,
                        ID_LISTBOX_MULTI,
                        HInstance,
                        nil
                        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, LB_ADDSTRING, 0, longint(pchar(' ')));

 ctl := CreateWindowEx (WS_EX_CLIENTEDGE,
                        'COMBOBOX',
                        '',
                        WS_CHILD or WS_VISIBLE or WS_VSCROLL or
                        CBS_DROPDOWN,
                        10,110,
                        135,100,
                        Wnd,
                        ID_COMBO_DROPDOWN,
                        HInstance,
                        nil
                        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));

 ctl := CreateWindowEx (WS_EX_CLIENTEDGE,
                        'COMBOBOX',
                        '',
                        WS_CHILD or WS_VISIBLE or WS_VSCROLL or
                        CBS_DROPDOWNLIST,
                        150,110,
                        135,100,
                        Wnd,
                        ID_COMBO_DROPDOWNLIST,
                        HInstance,
                        nil
                        );
 SendMessage (ctl, WM_SETFONT, hF, 0);
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 SendMessage (ctl, CB_ADDSTRING, 0, longint(pchar(' ')));
 end;

procedure ProcessCommand(Wnd : HWnd; Code : word; ID : word; Ctl : HWnd);
 var
   idx : dword;
   len : dword;
   str : pchar;
 begin
 case ID of
      ID_LISTBOX_SINGLE : case Code of
                               LBN_SELCHANGE : begin
                                               idx := SendMessage (Ctl, LB_GETCURSEL, 0, 0);
                                               len := SendMessage (Ctl, LB_GETTEXTLEN, idx, 0);
                                               getMem (str, len + 1);
                                               SendMessage (Ctl, LB_GETTEXT, idx, longint(str));
                                               SendMessage (Wnd, WM_SETTEXT, 0, longint(str));
                                               freeMem (str)
                                               end
                               end;
      ID_COMBO_DROPDOWN : case Code of
                               CBN_EDITCHANGE : begin
                                                len := SendMessage (Ctl, WM_GETTEXTLENGTH, 0, 0);
                                                getMem (str, len + 1);
                                                SendMessage (Ctl, WM_GETTEXT, len + 1, longint(str));
                                                if not (SendMessage (Ctl, CB_FINDSTRING, 0, longint(str)) = CB_ERR)
                                                   then begin
                                                        SendMessage (Ctl, CB_SELECTSTRING, 0, longint(str));
                                                        SendMessage (Ctl, CB_SETEDITSEL, 0, MAKELPARAM (len, -1))
                                                        end;
                                                freeMem (str)
                                                end
                               end
      end
 end;

function WndProc (
         Wnd : HWnd;
         Msg : cardinal;
         wParam, lParam : longint
         ) : longint; stdcall;
 begin
 result := 0;
 case Msg of
      WM_COMMAND : ProcessCommand (Wnd, HiWord (wParam), LoWord(wParam), HWnd(lParam));
      WM_CREATE : ProcessCreate (Wnd);
      WM_DESTROY : PostQuitMessage (0)
      else result := DefWindowProc (Wnd, Msg, wParam, lParam)
      end
 end;

var
  WndClass : PWndClassEx;

initialization
WndClass := new(PWndClassEx);
WndClass^.cbSize := sizeof(TWndClassEx);
WndClass^.style := CS_DBLCLKS or CS_HREDRAW or CS_OWNDC or CS_VREDRAW;
WndClass^.lpfnWndProc := @WndProc;
WndClass^.cbClsExtra := 0;
WndClass^.cbWndExtra := 0;
WndClass^.hInstance := HInstance;
WndClass^.hIcon := LoadIcon (0, IDI_ASTERISK);
WndClass^.hCursor := LoadCursor (0, IDC_ARROW);
WndClass^.hbrBackground := COLOR_BTNFACE + 1;
WndClass^.lpszMenuName := nil;
WndClass^.lpszClassName := CN_MAIN;
WndClass^.hIconSm := 0;
if RegisterClassEx (WndClass^) = 0
   then begin
        MessageBox (0, '  !', '!', MB_ICONSTOP);
        Halt (1)
        end;
dispose(WndClass)
end.
