{$MODE OBJFPC}

unit HelloWindow;

interface

uses
  Windows;

const
  CN_MAIN = 'our_main_window';

implementation

function WndProc (
         Wnd : HWnd;
         Msg : cardinal;
         wParam, lParam : longint
         ) : longint; stdcall;
 begin
 result := 0;
 case Msg of
      WM_DESTROY : PostQuitMessage (0)
      else result := DefWindowProc (Wnd, Msg, wParam, lParam)
      end
 end;

var
  WndClass : PWndClassEx;

initialization
WndClass := new(PWndClassEx);
WndClass^.cbSize := sizeof(TWndClassEx);
WndClass^.style := CS_DBLCLKS or CS_HREDRAW or CS_OWNDC or CS_VREDRAW;
WndClass^.lpfnWndProc := @WndProc;
WndClass^.cbClsExtra := 0;
WndClass^.cbWndExtra := 0;
WndClass^.hInstance := HInstance;
WndClass^.hIcon := LoadIcon (0, IDI_ASTERISK);
WndClass^.hCursor := LoadCursor (0, IDC_ARROW);
WndClass^.hbrBackground := COLOR_BTNFACE + 1;
WndClass^.lpszMenuName := nil;
WndClass^.lpszClassName := CN_MAIN;
WndClass^.hIconSm := 0;
if RegisterClassEx (WndClass^) = 0
   then begin
        MessageBox (0, '  !', '!', MB_ICONSTOP);
        Halt (1)
        end;
dispose(WndClass)
end.
