(*  tscript   *)
(*   Linux     ... *)
uses linux,stdio;

var
  dattr:termios;


procedure script(mfd:longint);
var
  nread, ofile:longint;
  _set, master:fdset;
  attr:termios;
  buf:array [0..511] of char;
begin
  (*         *)
  tcgetattr (0, attr);
  attr.c_cc[VMIN] := 1;
  attr.c_cc[VTIME] := 0;
  attr.c_lflag := attr.c_lflag and not (ISIG or ECHO or ICANON);
  tcsetattr (0, TCSAFLUSH, attr);

  (*    *)
  ofile := fdopen ('output', Open_CREAT or Open_WRONLY or Open_TRUNC, octal(0666));

  (*       select *)
  FD_ZERO (master);
  FD_SET (0, master);
  FD_SET (mfd, master);

  (*  select   ,
   *      . *)
  _set := master;
  while select (mfd + 1, @_set, nil, nil, nil) > 0 do
  begin
    (*    *)
    if FD_ISSET (0, _set) then
    begin
      nread := fdread (0, buf, 512);
      fdwrite (mfd, buf, nread);
    end;
    (*    *)
    if FD_ISSET (mfd, _set) then
    begin
      nread := fdread (mfd, buf, 512);
      write (ofile, buf, nread);
      write (1, buf, nread);
    end;
    _set := master;
  end;
end;

 
procedure runshell (sfd:longint);
begin
  setpgrp;
  dup2 (sfd, 0);
  dup2 (sfd, 1);
  dup2 (sfd, 2);
  execl ('/bin/sh -i');
end;


function pttyopen (var masterfd, slavefd:longint):integer;
var
  slavenm:pchar;
begin
  (*   -
   *      *)
  masterfd := fdopen ('/dev/ptmx', Open_RDWR);
  if masterfd = -1 then
  begin
    pttyopen:=-1;
    exit;
  end;
  (*       *)
  if grantpt (masterfd) = -1 then
  begin
    fdclose (masterfd);
    pttyopen:=-2;
    exit;
  end;
  (*   ,   mfd *)
  if unlockpt (masterfd) = -1 then
  begin
    fdclose (masterfd);
    pttyopen:=-3;
    exit;
  end;
  (*         *)
  slavenm := ptsname (masterfd);
  if slavenm = nil then
  begin
    fdclose (masterfd);
    pttyopen:=-4;
    exit;
  end;
  slavefd := fdopen (slavenm, Open_RDWR);
  if slavefd = -1 then
  begin
    fdclose (masterfd);
    pttyopen:=-5;
    exit;
  end;
  (*     *)
  ioctl (slavefd, I_PUSH, pchar('ptem'));
  if linuxerror>0 then
  begin
    fdclose (masterfd);
    fdclose (slavefd);
    pttyopen:=-6;
    exit;
  end;
  ioctl (slavefd, I_PUSH, pchar('ldterm'));
  if linuxerror>0 then
  begin
    fdclose (masterfd);
    fdclose (slavefd);
    pttyopen:=-7;
    exit;
  end;
  pttyopen:=1;
end;

 
procedure catch_child (signo:integer);cdecl;
begin
  tcsetattr (0, TCSAFLUSH, dattr);
  halt (0);
end;


var
  act:sigactionrec;
  mfd, sfd:longint;
  err:integer;
  buf:array [0..511] of char;
  mask:sigset_t;
begin

  (*     *)
  tcgetattr (0, dattr);
  (*   *)
  err := pttyopen (mfd, sfd);
  if err <> 1 then
  begin
    writeln (stderr, 'pttyopen: ', err);
    perror ('   ');
    halt (1);
  end;
  (*    SIGCHLD *)
  act.handler.sh := @catch_child;
  sigfillset (@mask);
  act.sa_mask:=mask.__val[0];
  sigaction (SIGCHLD, @act, nil);
  (*    *)
  case fork of
    -1:			(*  *)
    begin
      perror ('  ');
      halt (2);
    end;
    0:			(*   *)
    begin
      fdclose (mfd);
      runshell (sfd);
    end;
    else		(*   *)
    begin
      fdclose (sfd);
      script (mfd);
    end;
  end;
end.
