(*  testsem -      *)
uses ipc,stdio,linux;
{$i pv.inc}


(*  initsem -   *)
function initsem(semkey:tkey):longint;
var
  status, semid:longint;
  arg:tsemun;
begin
  status := 0;
  semid := semget (semkey, 1,
		       SEMPERM or IPC_CREAT or IPC_EXCL);
  if semid = -1 then
  begin
    if ipcerror = Sys_EEXIST then
      semid := semget (semkey, 1, 0);
  end
  else
    (*    ... *)
  begin
    arg.val := 1;
    status := semctl (semid, 0, SETVAL, arg);
  end;
  if (semid = -1) or (status = -1) then
  begin
    perror ('  initsem');
    initsem:=-1;
    exit;
  end;
  (*    *)
  initsem:=semid;
end;

(*  p.pas -  p   *)
function p (semid:longint):longint;
var
  p_buf:tsembuf;
begin
  p_buf.sem_num := 0;
  p_buf.sem_op := -1;
  p_buf.sem_flg := SEM_UNDO;
  if not semop (semid, @p_buf, 1) then
  begin
    perror ('  p(semid)');
    halt (1);
  end;
  p:=0;
end;

(*  v.pas -  v   *)
function v (semid:longint):longint;
var
  v_buf:tsembuf;
begin
  v_buf.sem_num := 0;
  v_buf.sem_op := 1;
  v_buf.sem_flg := SEM_UNDO;
  if not semop (semid, @v_buf, 1) then
  begin
    perror ('  v(semid)');
    halt (1);
  end;
  v:=0;
end;


procedure handlesem (skey:tkey);
var
  semid, pid:longint;
begin
  pid := getpid;

  semid := initsem (skey);
  if semid < 0 then
    halt (1);

  writeln (#$a' ',pid,'   ');
  p (semid);
  writeln (' ',pid,'   ');

  (*        *)
  sleep (10);

  writeln (' ',pid,'   ');
  v (semid);
  writeln (' ',pid,'  ');

  halt (0);
end;

const
  semkey:tkey = $200;
var
  i:integer;
begin
  for i := 1 to 3 do
    if fork = 0 then
      handlesem (semkey);
end.
