(*  stest --     *)
uses ipc,linux,stdio,sysutils;
{$i q.inc}

procedure warn (s:pchar);
begin
  writeln(stderr, ': ', s);
end;

(*   --    *)
function init_queue:longint;
var
  queue_id:longint;
begin
  (*       *)
  queue_id := msgget (QKEY, IPC_CREAT or QPERM);
  if queue_id = -1 then
    perror ('  msgget');
  init_queue:=queue_id;
end;


function proc_obj (msg:pq_entry):integer;
begin
  writeln(#$a': ',msg^.mtype,' : ',msg^.mtext);
end;


(*  serve --     
 *     
 *)
function serve:integer;
var
  r_qid:longint;
  r_entry:q_entry;
begin
  (*   ,    *)
  r_qid := init_queue;
  if r_qid = -1 then
  begin
    serve:=-1;
    exit;
  end;

  (*      *)
  while true do
  begin
    if not msgrcv (r_qid, @r_entry, MAXOBN, (-1 * MAXPRIOR), MSG_NOERROR) then
    begin
      perror ('  msgrcv');
      serve:=-1;
      exit;
    end
    else
    begin
      (*    *)
      proc_obj (@r_entry);
    end;
  end;
end;


var
  pid:longint;
begin
  pid := fork;
  case pid of
    0:			(*   *)
      serve;
    -1:                 (*    *)
      warn ('   ');
    else
      writeln('    ', pid);
  end;
  if pid <> -1 then
    halt (0)
  else
    halt (1);
end.
