(*  showmsg -      *)
{$mode objfpc}
uses ipc,stdio,sysutils;

procedure mqstat_print(mkey:tkey; msq_id:longint; mstat:pmsqid_ds);
begin
  writeln (#$a' ', mkey, ', msg_qid ', msq_id, #$a);
  writeln(mstat^.msg_qnum, '   '#$a);

  writeln('    ', mstat^.msg_lspid, '  ',
         ctime(mstat^.msg_stime));
  writeln('    ', mstat^.msg_lrpid, '  ',
         ctime(mstat^.msg_rtime));
end;


var
  mkey:tkey;
  msq_id:longint;
  msq_status:tmsqid_ds;
begin
  if paramcount<>1 then
  begin
    writeln(stderr, ': showmsg _');
    halt(1);
  end;

  (*     *)
  try
    mkey:=tkey(strtoint(paramstr(1)));
  except
    on e:econverterror do
    begin
      writeln(stderr, '   ');
      halt (2);
    end;
  end;
  
  msq_id := msgget(mkey, 0);
  if msq_id = -1 then
  begin
    perror('  msgget');
    halt(2);
  end;

  (*     *)
  if not msgctl(msq_id, IPC_STAT, @msq_status) then
  begin
    perror('  msgctl');
    halt(3);
  end;

  (*     *)
  mqstat_print(mkey, msq_id, @msq_status);
  halt(0);
end.
