(*  etest --     . *)
{$mode objfpc}
uses ipc,linux,stdio,sysutils;
{$i q.inc}

procedure warn (s:pchar);
begin
  writeln(stderr, ': ', s);
end;

(*   --    *)
function init_queue:longint;
var
  queue_id:longint;
begin
  (*       *)
  queue_id := msgget (QKEY, IPC_CREAT or QPERM);
  if queue_id = -1 then
    perror ('  msgget');
  init_queue:=queue_id;
end;


(*  enter --     *)
function enter (objname:string;priority:longint):boolean;
var
  len, s_qid:longint;
  s_entry:q_entry;	(*     *)
begin
  (*       *)
  len := length (objname);
  if len > MAXOBN then
  begin
    warn ('  ');
    enter:=false;
    exit;
  end;
  if (priority > MAXPRIOR) or (priority < 0) then
  begin
    warn ('  ');
    enter:=false;
    exit;
  end;

  (*   ,    *)
  s_qid := init_queue;
  if s_qid = -1 then
  begin
    enter:=false;
    exit;
  end;
  (*    s_entry *)
  s_entry.mtype := priority;
  strlcopy (s_entry.mtext, @objname[1], MAXOBN);
  (*  ,  ,    *)
  if not msgsnd (s_qid, @s_entry, len, 0) then
  begin
    perror ('  msgsnd');
    enter:=false;
    exit;
  end
  else
    enter:=true;
end;


var
  priority:longint;
begin
  if paramcount <> 2 then
  begin
    writeln(stderr, ': ',paramstr(0),'  ');
    halt (1);
  end;
  try
    priority:=strtoint(paramstr(2));
  except
    on e:econverterror do
    begin
      warn (' ');
      halt (2);
    end;
  end;
  if (priority <= 0) or (priority > MAXPRIOR) then
  begin
    warn (' ');
    halt (2);
  end;
  if not enter (paramstr(1), priority) then
  begin
    warn ('   enter');
    halt (3);
  end;
  halt (0);
end.
