(*  deadlock -   *)
uses linux, stdio;

function fatal (s:pchar):integer;
begin
  perror (s);
  halt (1);
end;

var
  fd:longint;
  first_lock, second_lock:flockrec;
begin
  first_lock.l_type := F_WRLCK;
  first_lock.l_whence := SEEK_SET;
  first_lock.l_start := 0;
  first_lock.l_len := 10;
  second_lock.l_type := F_WRLCK;
  second_lock.l_whence := SEEK_SET;
  second_lock.l_start := 10;
  second_lock.l_len := 5;

  writeln(sizeof(flockrec));
  fd := fdopen ('locktest', Open_RDWR);

  fcntl (fd, F_SETLKW, longint(@first_lock));
  if linuxerror>0 then	(*A *)
    fatal ('A');

  writeln ('A:   ( ',getpid,')');

  case fork of
    -1:
      (*  *)
      fatal ('  fork');
    0:
    begin
      (*   *)
      fcntl (fd, F_SETLKW, longint(@second_lock));
      if linuxerror>0 then	(*B *)
	fatal ('B');
      writeln ('B:   ( ',getpid,')');
      fcntl (fd, F_SETLKW, longint(@first_lock));
      if linuxerror>0 then	(*C *)
	fatal ('C');
      writeln ('C:   ( ',getpid,')');
      halt (0);
    end;
    else
    begin
      (*   *)
      writeln ('  ');
      sleep (10);
      fcntl (fd, F_SETLKW, longint(@second_lock));
      if linuxerror>0 then	(*D *)
	fatal ('D');
      writeln ('D:   ( ',getpid,')');
    end;
  end;
end.
