(*        *)
uses linux,stdio;

var
  count:integer;

(*     SIGALRM *)
procedure alrm_action(signo:integer);cdecl;
begin
  writeln ('    ',count,' ');
  halt (0);
end;

const
  c:char='x';
var
  fdin,fdout,pipe_size:longint;
  act:sigactionrec;
  temp:sigset_t;
begin
  (*    *)
  act.handler.sh := @alrm_action;
  sigfillset (@temp);
  act.sa_mask:=temp.__val[0];
  (*   *)
  if not assignpipe (fdin,fdout) then
  begin
    perror ('  pipe ');
    halt (1);
  end;
  (*    *)
  pipe_size := fpathconf (fdin, _PC_PIPE_BUF);
  writeln('  : ',pipe_size,' ');
  (*    *)
  sigaction (SIGALRM, @act, nil);
  while true do
  begin
    (*   *)
    alarm (20);
    (*    *)
    fdwrite (fdout, c, 1);
    (*   *)
    alarm (0);
    inc(count);
    if count mod 1024 = 0 then
      writeln (count, '   ');
  end;
end.
