(*      *)
uses linux, stdio;

const
  MSGSIZE=16;
  msg1:array [0..MSGSIZE-1] of char = 'hello, world #1';
  msg2:array [0..MSGSIZE-1] of char = 'hello, world #2';
  msg3:array [0..MSGSIZE-1] of char = 'hello, world #3';

var
  inbuf:array [0..MSGSIZE-1] of char;
  fdr,fdw,j,pid:longint;
begin
  (*   *)
  if not assignpipe (fdr,fdw) then
  begin
    perror ('  pipe ');
    halt (1);
  end;
  pid := fork;
  case pid of
    -1:
    begin
      perror ('  fork');
      halt (2);
    end;
    0:
    begin
      (*   ,     *)
      fdwrite (fdw, msg1, MSGSIZE);
      fdwrite (fdw, msg2, MSGSIZE);
      fdwrite (fdw, msg3, MSGSIZE);
    end;
    else
    begin
      (*   ,     *)
      for j := 1 to 3 do
      begin
        fdread (fdr, inbuf, MSGSIZE);
	writeln (inbuf);
      end;
      wait(nil);
    end;
  end;
  halt (0);
end.
