(*  rcvmessage -     fifo *)
uses linux,stdio;

const
  MSGSIZ=63;
  fifo  = 'fifo';


function fatal (s:pchar):integer;
begin
  perror (s);
  halt (1);
end;


var
  fd:integer;
  msgbuf:array [0..MSGSIZ] of char;
begin
  (*   fifo,      *)
  if not mkfifo (fifo, octal(0666)) then
    if linuxerror <> Sys_EEXIST then
      fatal (' :  mkfifo');

  (*   fifo    . *)
  fd := fdopen (fifo, Open_RDWR);
  if fd < 0 then
    fatal ('    fifo');

  (*   *)
  while true do
  begin
    if fdread (fd, msgbuf, MSGSIZ + 1) < 0 then
      fatal ('   ');
    (*
     *  ;   
     *     -
     *  .
     *)

    writeln(' : ', msgbuf);
  end;
end.
