(*  join -     *)
uses linux,stdio;

function fatal (s:pchar):integer;
begin
  perror (s);
  halt (1);
end;


function join (com1, com2:ppchar):integer;
var
  fdin,fdout:longint;
  status:integer;
begin
  (*       *)
  case fork of
    -1:			(*  *)
      fatal (' 1  fork   join');
    0:			(*   *)
      ;
    else			(*   *)
    begin
      wait(@status);
      join:=status;
      exit;
    end;
  end;
  (*  ,    *)
  (*   *)
  if not assignpipe(fdin,fdout) then
    fatal ('  pipe   join');
  (*     *)
  case fork of
    -1:
      (*  *)
      fatal (' 2  fork   join');
    0:
    begin
      (* ,   *)
      dup2 (fdout, 1);		(*  .    *)
      fdclose (fdin);		(*    *)
      fdclose (fdout);
      execvp (com1[0], com1, envp);
      (*  execvp  ,    *)
      fatal (' 1  execvp   join');
    end;
    else
    begin
      (* ,   *)
      dup2 (fdin, 0);		(*  .    *)
      fdclose (fdin);
      fdclose (fdout);
      execvp (com2[0], com2, envp);
      fatal (' 2  execvp   join');
    end;
  end;
end;


const
  one:array [0..3] of pchar = ('ls', '-l', '/usr/lib', nil);
  two:array [0..2] of pchar = ('grep', '^d', nil);
var 
  ret:integer;
begin
  ret := join (one, two);
  writeln ('   join ', ret);
  halt (0);
end.
