uses linux,stdio;

procedure fatal(s:pchar);
begin
  perror(s);
  halt(1);
end;


var
  pid:longint;
  status, exit_status, sig_no:integer;
begin
  pid := fork;
  if pid < 0 then
    fatal ('  fork ');
  if pid = 0 then			(*  *)
  begin
    (*    sleep
     *     20 
     *)
    writeln (' ',getpid,',  20  ...');
    sleep(20);
    halt(5);			(*     *)
  end;
  (*    ,     *)
  pid := wait (@status);
  if pid = -1 then
  begin
    perror ('  wait');
    halt(1);
  end;
  (*      *)
  if WIFEXITED (status) then
  begin
    exit_status := WEXITSTATUS (status);
    writeln ('  ',pid,'  ', exit_status);
  end;
  (* ,      *)
  if WIFSIGNALED (status) then
  begin
    sig_no := WTERMSIG (status);
    writeln ('  ',sig_no,'   ', pid);
    if WCOREDUMP (status) then
      writeln ('...    ');
  end;
  (*    . *)
  if WIFSTOPPED (status) then
  begin
    sig_no := WSTOPSIG (status);
    writeln ('  ',sig_no,'   ', pid);
  end;
  halt(0);
end.
