(* tml -    *)
{$mode objfpc}

uses linux, stdio, sysutils;

const
  BELLS=#7#7#7;	(*   ASCII *)
  alarm_flag:boolean = FALSE;

(*   SIGALRM *)
procedure setflag(sig:integer);cdecl;
begin
  alarm_flag := TRUE;
end;

var
  nsecs, j:integer;
  pid:longint;
  act:sigactionrec;
begin
  if paramcount < 2 then
  begin
    writeln (stderr, ': tml _ ');
    halt(1);
  end;
  try
    nsecs := strtoint(paramstr(1)) * 60;
  except
    on e:econverterror do
    begin
      writeln (stderr, '  ');
      halt(2);
    end;  
  end;
  if nsecs <= 0 then
  begin
    writeln (stderr, 'tml:  ');
    halt(3);
  end;

  (*  fork,    *)
  pid := fork;
  case pid of
    -1:			(*  *)
    begin
      perror ('tml');
      halt(1);
    end;
    0:			(*   *)
      ;
    else		(*   *)
    begin
      writeln(' tml   ', pid);
      halt(0);
    end;
  end;

  (*    *)
  act.handler.sh := @setflag;
  sigaction (SIGALRM, @act, nil);
  (*   *)
  alarm (nsecs);
  (*      ... *)
  pause;

  (*     SIGALRM,   *)
  if alarm_flag then
  begin
    write(BELLS);
    for j := 2 to paramcount do
      write(paramstr(j),' ');
    writeln;
  end;
  halt(0);
end.
