(*  synchro --    kill *)
uses linux,stdio;

const
  ntimes:integer=0;

procedure p_action(sig:integer);cdecl;
begin
  inc(ntimes);
  writeln ('    ', ntimes, ' ()');
end;

procedure c_action(sig:integer);cdecl;
begin
  inc(ntimes);
  writeln ('    ', ntimes, ' ()');
end;


var
  pid, ppid:longint;
  pact, cact:sigactionrec;
begin
  (*    SIGUSR1    *)
  pact.handler.sh := @p_action;
  sigaction (SIGUSR1, @pact, nil);

  pid := fork;
  case pid of
    -1:			(*  *)
    begin
      perror ('synchro');
      halt(1);
    end;
    0:			(*   *)
    begin
      (*      *)
      cact.handler.sh := @c_action;
      sigaction (SIGUSR1, @cact, nil);
      (*     *)
      ppid := getppid;
      while true do
      begin
        sleep (1);
        kill (ppid, SIGUSR1);
        pause;
      end;
      (*   *)
    end;
    else			(*   *)
      while true do
      begin
        pause;
	sleep (1);
	kill (pid, SIGUSR1);
      end;
      (*   *)
  end;
end.
