uses linux,stdio;

const
  TIMEOUT=5;		(*    *)
  MAXTRIES=5;		(*   *)
  LINESIZE=100;		(*   *)
  CTRL_G=#7;		(* ASCII    *)

var
  (* , ,     *)
  timed_out:boolean;
  (* ,      *)
  answer:array [0..LINESIZE-1] of char;

(*     SIGALRM *)
procedure catch (sig:integer);cdecl;
begin
  (*   timed_out *)
  timed_out := TRUE;
  (*    *)
  write(CTRL_G);
end;


function quickreply(prompt:pchar):pchar;
var
  ntries:integer;
  act, oact:sigactionrec;
begin
  (*   SIGALRM     *)
  act.handler.sh := @catch;
  sigaction (SIGALRM, @act, @oact);
  for ntries:=1 to MAXTRIES do
  begin
    timed_out := FALSE;
    writeln;
    write(prompt, ' > ');
    (*   *)
    alarm (TIMEOUT);
    (*    *)
    gets (answer);
    (*   *)
    alarm (0);
    (*   timed_out  TRUE,   *)
    if not timed_out then
      break;
  end;
  (*    *)
  sigaction (SIGALRM, @oact, nil);
  (*    *)
  if ntries = MAXTRIES then 
    quickreply:=nil
  else quickreply:=answer;
end;


begin
  writeln;
  writeln(quickreply ('Reply'));
end.
