(*  status2 --   
 *      waitpid
 *)
uses linux,stdio,crt;

procedure fatal(s:pchar);
begin
  perror(s);
  halt(1);
end;

var
  pid:longint;
  status, exit_status:integer;
begin
  pid := fork;
  if pid < 0 then
    fatal ('  fork ');

  if pid = 0 then			(*  *)
  begin
    (*    sleep
     *     4 
     *)
    writeln (' ',getpid,' ...');
    sleep(4);
    halt(5);			(*     *)
  end;

  (*    ,     *)
  (* ,    ,   ,  *)
  (*    ,         *)
  while (waitpid (pid, @status, WNOHANG) = 0) do
  begin
    writeln (' ...\n');
    sleep(1);
  end;

  (*      *)
  if WIFEXITED (status) then
  begin
    exit_status := WEXITSTATUS (status);
    writeln ('  ',pid,'  ', exit_status);
  end;

  halt(0);
end.
