(*  status --     *)
uses linux,stdio,crt;

procedure fatal(s:pchar);
begin
  perror(s);
  halt(1);
end;

var
  pid:longint;
  status, exit_status:integer;
begin
  pid := fork;
  if pid < 0 then
    fatal ('  fork ');
  if pid = 0 then			(*  *)
  begin
    (*    sleep
     *      4 
     *)
    sleep(4);
    halt(5);			(*     *)
  end;
  (*    ,    , *)
  (*              *)
  pid := wait(@status);
  if pid = -1 then
  begin
    perror ('  wait ');
    halt(2);
  end;
  (*      *)
  if WIFEXITED (status) then
  begin
    exit_status := WEXITSTATUS (status);
    writeln ('  ',pid,'  ', exit_status);
  end;
  halt(0);
end.
