uses stdio,linux;

{$i smallsh.inc}
(*      *)
var
  inpbuf:array [0..MAXBUF-1] of char;
  tokbuf:array [0..2*MAXBUF-1] of char;
const
  ptr:pchar=@inpbuf[0];
  tok:pchar=@tokbuf[0];
  special:array [0..5] of char = (' ', #9, '&', ';', #$a, #0);

function runcommand(cline:ppchar;where:integer):integer;forward;
function inarg(c:char):boolean;forward;

(*      *)
function userin(p:pchar):integer;
var
  c, count:integer;
begin
  (*     *)
  ptr := inpbuf;
  tok := tokbuf;
  (*   *)
  write(p);
  count := 0;
  while true do
  begin
    c := getchar;
    if c = EOF then
    begin
      userin:=EOF;
      exit;
    end;
    if count < MAXBUF then
    begin
      inpbuf[count] := char(c);
      inc(count);
    end;
    if (c = $a) and (count < MAXBUF) then
    begin
      inpbuf[count] := #0;
      userin:=count;
      exit;
    end;
    (*    ,   *)
    if c = $a then
    begin
      writeln ('smallsh:    ');
      count := 0;
      write (p);
    end;
  end;
end;

(*        tokbuf *)
function gettok (outptr:ppchar):integer;
var
  _type:integer;
begin
  (*     outptr  tok *)
  outptr^ := tok;
  (*    ,   *)
  while (ptr^ = ' ') or (ptr^ = #9) do
    inc(ptr);
  (*        *)
  tok^ := ptr^;
  inc(tok);
  (*    type  
   *      *)
  case ptr^ of
    #$a:
    begin
      _type := EOL;
      inc(ptr);
    end;
    '&':
    begin
      _type := AMPERSAND;
      inc(ptr);
    end;
    ';':
    begin
      _type := SEMICOLON;
      inc(ptr);
    end;
    else
    begin
      _type := ARG;
      inc(ptr);
      (*     *)
      while inarg (ptr^) do
      begin
        tok^ := ptr^;
	inc(tok);
	inc(ptr);
      end;
    end;
  end;
  tok^ := #0;
  inc(tok);
  gettok:=_type;
end;


function inarg(c:char):boolean;
var
  wrk:pchar;
begin
  wrk := special;
  while wrk^<>#0 do
  begin
    if c = wrk^ then
    begin
      inarg:=false;
      exit;
    end;
    inc(wrk);
  end;
  inarg:=true;
end;

function procline:integer;	(*    *)
var
  arg:array [0..MAXARG] of pchar;	(*    runcommand *)
  toktype:integer;			(*     *)
  narg:integer;				(*   *)
  _type:integer;			(*       *)
begin
  narg := 0;
  while true do			(*   *)
  begin
    (*        *)
    toktype := gettok (@arg[narg]);
    case toktype of
      2://ARG
        if narg < MAXARG then
          inc(narg);
      1,3,4://EOL,SEMICOLON, AMPERSAND:
      begin
        if toktype = AMPERSAND then
          _type := BACKGROUND
        else
          _type := FOREGROUND;
        if narg <> 0 then
        begin
          arg[narg] := nil;
          runcommand (arg, _type);
        end;
        if toktype = EOL then
	  exit;
        narg := 0;
      end;
    end;
  end;
end;

(*  ,     *)
function runcommand(cline:ppchar;where:integer):integer;
var
  pid:longint;
  status:integer;
begin
  pid := fork;
  case pid of
    -1:
    begin
      perror ('smallsh');
      runcommand:=-1;
      exit;
    end;
    0:
    begin
      execvp (cline^, cline, envp);
      perror (cline^);
      halt(1);
    end;
  end;

  (*    *)
  (*    ,  pid   *)
  if where = BACKGROUND then
  begin
    writeln ('[  ',pid,']');
    runcommand:=0;
    exit;
  end;

  (*      pid *)
  if waitpid (pid, @status, 0) = -1 then
    runcommand:=-1
  else
    runcommand:=status;
end;

const
  prompt = 'Command> ';	(*     *)
begin
  while userin (prompt) <> EOF do
    procline;
end.
