(*  runls3 --  ls   *)
uses linux,stdio;

procedure fatal(s:pchar);
begin
  perror(s);
  halt(1);
end;


var
  pid:longint;
begin
  pid := fork;
  case pid of
    -1:
      fatal ('  fork');
    0:
    begin
      (*   exec *)
      execl('/bin/ls -l');
      fatal('  exec ');
    end;
    else
    begin
      (*    wait  
       *     .
       *)
      wait(nil);
      writeln(' ls ');
      halt(0);
    end;
  end;
end.
