(*  proc_file --     *)
(* ,    "data"   20  *)
uses linux,stdio;

procedure fatal(s:pchar);
begin
  perror(s);
  halt(1);
end;

(*     *)
procedure printpos(_string:pchar;filedes:integer);
var
  pos:longint;
begin
  pos := fdseek (filedes, 0, SEEK_CUR);
  if pos=-1 then
    fatal ('  lseek');
  writeln(_string,':',pos);
end;


var
  fd:integer;
  pid:longint;			(*   *)
  buf:array [0..9] of char;	(*     *)
begin
  fd := fdopen ('data', Open_RDONLY);
  if fd = -1 then
    fatal ('  open ');

  fdread (fd, buf, 10);		(*     *)
  printpos ('  fork', fd);
  (*    *)

  pid := fork;
  case pid of
    1:			(*  *)
      fatal ('  fork ');
    0:			(*  *)
    begin
      printpos ('   ', fd);
      fdread (fd, buf, 10);
      printpos ('   ', fd);
    end;
    else			(*  *)
    begin
      wait(nil);
      printpos ('   ', fd);
    end;
  end;
end.
