uses linux,strings;

function match(s1, s2: pchar):boolean;forward;

function find_entry(dirname:pchar;suffix:pchar;cont:integer):pchar;
const
  dp:pdir=nil;
var
  d:pdirent;
begin
  if (dp = nil) or (cont = 0) then
  begin
    if dp <> nil then
      closedir (dp);
    dp:=opendir(dirname);
    if dp = nil then
    begin
      find_entry:=nil;
      exit;
    end;
  end;

  d := readdir (dp);
  while d <> nil do
  begin
    if d^.ino = 0 then
	continue;
    if match (d^.name, suffix) then
    begin
      find_entry:=d^.name;
      exit;
    end;
    d := readdir (dp);
  end;

  closedir (dp);
  dp := nil;
  find_entry:=nil;
end;

 
function match(s1, s2: pchar):boolean;
var
  diff:integer;
begin
  diff := strlen (s1) - strlen (s2);

  if strlen (s1) > strlen (s2) then
    match:=(strcomp (@s1[diff], s2) = 0)
  else
    match:=false;
end;

var 
  name:pchar;
  arg1,arg2:array [0..100] of char;
begin
  if paramcount<2 then
    halt(1);
  strpcopy(arg1,paramstr(1));
  strpcopy(arg2,paramstr(2));
  name := find_entry (arg1, arg2, 1);
  while name<>nil do
  begin
    writeln(name);
    name := find_entry (arg1, arg2, 1);
  end;
end.
