(*  lookout     *)

uses linux,stdio;

const
  MFILE=10;

var
  sb:tstat;
  j:integer;
  last_time:array [1..MFILE] of longint;

procedure sleep(t:longint);cdecl;external 'c';

procedure cmp(name:string;last:longint);
begin
  (*
   *    ,
   *      .
   *)
  if not fstat(name,sb) or (sb.mtime <> last) then
  begin
    writeln('lookout:  ',name,' ');
    halt(0);
   end;
end;


begin
  if (paramcount < 1) then
  begin
    writeln(': lookout _ ...');
    halt(1);
  end;
  if (paramcount > MFILE) then
  begin
    writeln('lookout:    ');
    halt (1);
  end;
  (*  *)
  for j:=1 to paramcount do
  begin
    if not fstat(paramstr(j), sb) then
    begin
      writeln ('lookout:   stat  ', paramstr(j));
      halt(1);
    end;
    last_time[j]:=sb.mtime;
  end;
  (*    ,     *)
  while true do
  begin
    for j:=1 to paramcount do
      cmp(paramstr(j), last_time[j]);
      (*
       *   60 .
       *  'sleep' 
       *   UNIX.
       *)
    sleep (60);
  end;
end.


