(*  filedata     *)
uses linux;

(*
 *  octarray   
 *    .
 *)
const
  octarray:array[0..8] of integer= (
              0400, 0200, 0100,
              0040, 0020, 0010,
              0004, 0002, 0001);

(*
 *       ,
 *  10 ,      .
 *)
const 
  perms:pchar = 'rwxrwxrwx';

function filedata(pathname:string):integer;
var
  statbuf:tstat;
  descrip:array [0..9] of char;
  j:integer;
begin
  if not fstat (pathname, statbuf) then
  begin
    writeln('  stat  ', pathname);
    filedata:=-1;
    exit;
  end;

  (*       *)
  for j:=0 to 8 do
  begin
      (*
       * ,    
       *    
       *)
      if (statbuf.mode and octal(octarray[j]))<>0 then
	descrip[j] := perms[j]
      else
	descrip[j] := '-';
  end;
  descrip[9] := #0;		(*   *)
  (*     *)
  writeln(#10' ', pathname, ':');
  writeln(' ',statbuf.size,' ');
  writeln('User-id ',statbuf.uid,', Group-id ',statbuf.gid,#10);
  writeln(' : ', descrip);
  filedata:=0;
end;

begin
  if (paramcount > 0) then
      filedata(paramstr(1));
end.
