(*  getoccupier     residents *)

uses linux;

const
  NAMELENGTH=41;

var
  namebuf:array [0..NAMELENGTH-1] of char;	(*    *)
const
  infile:integer=-1;		(*     *)

function getoccupier(roomno:integer):pchar;
var
  offset, nread:longint;
begin
  (* ,     *)
  if infile = -1 then
  begin 
    infile := fdopen ('residents', Open_RDWR);
    if infile = -1 then
    begin
      getoccupier := nil;		(*    *)
      exit;
    end;
  end;

  offset := (roomno - 1) * NAMELENGTH;

  (*        *)
  if fdseek (infile, offset, SEEK_SET) = -1 then
  begin
    getoccupier := nil;
    exit;
  end;

  nread := fdread (infile, namebuf, NAMELENGTH);
  if nread <= 0 then
  begin
    getoccupier := nil;
    exit;
  end;

  (*  ,      '\0' *)
  namebuf[nread - 1] := #0;
  getoccupier := namebuf;
end;

(*  listoc     *)

const
  NROOMS=10;

var
  j:integer;
  p:pchar;
begin

  for j := 1 to NROOMS do
  begin
    p := getoccupier (j);
    if p<>nil then
      writeln(' ', j:2, ', ', p)
    else
      writeln('   ', j);
  end;
end.
