(*
 *  filestatus    
 *)

uses linux;

function filestatus(filedes:integer):integer;
var
  arg1:integer;
begin
  arg1 := fcntl (filedes, F_GETFL);
  if arg1 = -1 then
  begin
    writeln('   ');
    filestatus := -1;
    exit;
  end;

  write('  ', filedes, ': ');

  (*
   *      . 
   *)
  case (arg1 and Open_ACCMODE) of
    Open_WRONLY:
      write('  ');
    Open_RDWR:
      write(' -');
    Open_RDONLY:
      write('  ');
    else
      write('  ');
  end;

  if (arg1 and Open_APPEND)<>0 then
    write (' -   append');
  writeln;
  filestatus := 0;
end;

var
  fd:integer;
begin
  if paramcount > 0 then
  begin
    fd := fdopen (paramstr(1), Open_WRONLY or Open_APPEND, 0);
    if fd <> -1 then
    begin
      filestatus (fd);
      fdclose (fd);
    end;
  end;
end.
