(*  copyfile:   name1   name2 *)

uses linux;

const
  BUFSIZE=512;		(*    *)
  PERM=0644;		(*       ,
                              *)

(*   name1   name2 *)
function copyfile(name1, name2: string):integer;
var
  infile, outfile: integer; (* *)
  nread: longint;
  buffer: array [0..BUFSIZE-1] of byte; (*  /*)
begin

  infile := fdopen (name1, Open_RDONLY);
  if infile=-1 then
  begin
    copyfile:=-1; (*   *)
    exit;
  end;

  outfile := fdopen (name2, Open_WRONLY or Open_CREAT or Open_TRUNC, octal(PERM));
  if outfile=-1 then
  begin
    fdclose(infile);
    copyfile:=-2; (*   *)
    exit;
  end;

  (*    name1  BUFSIZE  *)
  nread := fdread (infile, buffer, BUFSIZE);
  while nread > 0 do
  begin
    (*  buffer   . *)
    if fdwrite (outfile, buffer, nread) < nread then
    begin
      fdclose (infile);
      fdclose (outfile);
      copyfile:=-3;		(*   *)
      exit;
    end;
    nread := fdread (infile, buffer, BUFSIZE);
  end;

  (*  *)
  fdclose (infile);
  fdclose (outfile);

  if (nread = -1) then
    copyfile := -4		(*     *)
  else				
    copyfile := 0;              (*   *)
end;

(*     copyfile *)
var
  retcode:integer;
begin
  if paramcount<2 then
  begin
    writeln(': ',paramstr(0),' - -');
    exit;
  end;
  retcode := copyfile(paramstr(1), paramstr(2));
  case retcode of
     0:  writeln(' ',paramstr(1),'     ',paramstr(2));
    -1:  writeln('   ',paramstr(1),'  ');
    -2:  writeln('   ',paramstr(2),'  ');
    -3:  writeln('    ',paramstr(2));
    -4:  writeln('    ',paramstr(1));
  end;
end.
