uses linux;

var
  i, input, output, filesize:longint;
  source, target:pchar;
  args:tmmapargs;
const  
  endchar:char=#0;
type 
  oearray=array [0..0] of char;
  poearray=^oearray;
begin
  (*     *)
  if paramcount <> 2 then
  begin
    writeln(stderr, ': copyfile  ');
    halt (1);
  end;

  (*      *)
  input := fdopen (paramstr(1), Open_RDONLY);
  if input = -1 then
  begin
    writeln(stderr, '    ', paramstr(1));
    halt (1);
  end;

  output := fdopen (paramstr(2), Open_RDWR or Open_CREAT or Open_TRUNC, octal(0666));
  if output = -1 then
  begin
    fdclose (input);
    writeln(stderr, '    ', paramstr(2));
    halt (2);
  end;

  (*       ,   . *)
  filesize := fdseek (input, 0, SEEK_END);
  fdseek (output, filesize - 1, SEEK_SET);
  fdwrite (output, endchar, 1);

  (*       . *)
  args.fd:=input;
  args.flags:=MAP_SHARED;
  args.prot:=PROT_READ;
  args.size:=filesize;
  args.address:=0;
  args.offset:=0;
  source:=pchar(mmap(args));
  if longint(source) = -1 then
  begin
    writeln(stderr, '   1  ');
    halt (1);
  end;

  args.fd:=output;
  args.flags:=MAP_SHARED;
  args.prot:=PROT_WRITE;
  args.size:=filesize;
  args.address:=0;
  args.offset:=0;
  target:=pchar(mmap(args));
  if longint(target) = -1 then
  begin
    writeln(stderr, '   2  ');
    halt (1);
  end;

  (*  *)
  for i:=0 to filesize-1 do
    poearray(target)^[i] := poearray(source)^[i];

  (*     *)
  munmap (source, filesize);
  munmap (target, filesize);
  (*    *)
  fdclose (input);
  fdclose (output);
  halt (0);
end.
