(*  yesno --     *)
uses stdio;

const
  YES=1;
  NO=0;
  ANSWSZ=80;
  pdefault:pchar = ' "y" (YES),  "n" (NO)';
  error:pchar = ' ';


function yesno (prompt:pchar):integer;
var
  buf:array [0..ANSWSZ-1] of char;
  p_use, p:pchar;
begin
  (*  ,     nil.
   *     
   * pdefault *)
  if prompt <> nil then
    p_use := prompt
  else
    p_use := pdefault;
  (*      . *)
  while true do
  begin
    (*   *)
    printf ('%s > ', [p_use]);
    if fgets (buf, ANSWSZ, stdin) = nil then
    begin
      yesno:=EOF;
      exit;
    end;
    (*    *)
    p := buf; 
    while isspace (byte(p^)) do
      inc(p);
    case p^ of
      'Y','y':
      begin
        yesno:=YES;
        exit;
      end;
      'N','n':
      begin
        yesno:=NO;
        exit;
      end;
      else
        printf (#$a'%s'#$a, [error]);
    end;
  end;
end;


var
  ans:integer;
begin
  ans := yesno (nil);
  printf (' : ',[]);
  if ans = YES then
    printf (''#$a,[])
  else
    printf (''#$a,[]);
end.
