(*  egetc -- getc    *)
uses stdio;

function egetc (stream:pfile):longint;
var
  c:longint;
begin
  c := getc (stream);
  if c = EOF then
  begin
    if ferror (stream) <> 0 then
    begin
      writeln (stderr, ' :  ');
      halt (1);
    end
    else
      writeln (stderr, ': EOF');
  end;
  egetc:=c;
end;


var
  c:longint;
begin
  c := egetc (stdin);
  while c <> -1 do
  begin
    putc (c, stdout);
    c := egetc (stdin);
  end;
end.
