(* getlist -        *)

uses stdio, strings;

const
  MAXLEN=255; (*     *)
  MAXCMD=100; (*    *)
  ERROR=-1;
  SUCCESS=0;

type
  sarray=array [0..MAXLEN] of char;
  darray=array [0..MAXCMD] of sarray;
  

function getlist(namepart:pchar; var dirnames:darray; maxnames:integer):integer;
var
  cmd:array [0..MAXCMD] of char;
  in_line:array [0..MAXLEN+1] of char;
  i:integer;
  lsf:pfile;
begin
  (*   *)
  strcopy(cmd, 'ls ');

  (*    *)
  if namepart <> nil then
    strlcat(cmd, namepart, MAXCMD - strlen(cmd));

  lsf := pipeopen(cmd, 'r'); (*   *)
  if lsf = nil then
  begin
    getlist:=ERROR;
    exit;
  end;

  for i:=0 to maxnames-1 do
  begin
    if fgets(in_line, MAXLEN+2, lsf) = nil then
      break;

    (*     *)
    if in_line[strlen(in_line)-1] = #$a then
      in_line[strlen(in_line)-1] := #0;

    strcopy(dirnames[i], in_line);
  end;
  if i < maxnames then
    dirnames[i][0] := #0;

  pipeclose (lsf);
  getlist:=SUCCESS;
end;

var
  namebuf:darray;
  i:integer;
begin
  getlist('*.pas', namebuf, 100);
  i:=0;
  while namebuf[i][0]<>#0 do
  begin
    writeln(namebuf[i]);
    inc(i);
  end;
end.